/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Predicate;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;

public class FilteredExpression
extends AbstractExpression {
    protected final Expression expression;
    protected final List predicates = new ArrayList(2);

    public FilteredExpression(XQueryContext context, Expression expr) {
        super(context);
        this.expression = expr;
    }

    public void addPredicate(Predicate pred) {
        this.predicates.add(pred);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            Predicate pred = (Predicate)i.next();
            pred.analyze(contextInfo);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if ((seq = this.expression.eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            result = seq;
            Iterator i = this.predicates.iterator();
            while (i.hasNext()) {
                Predicate pred = (Predicate)i.next();
                result = pred.evalPredicate(contextSequence, result, 8);
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        this.expression.dump(dumper);
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            ((Expression)i.next()).dump(dumper);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.expression.toString());
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            result.append(((Expression)i.next()).toString());
        }
        return result.toString();
    }

    public int returnsType() {
        return this.expression.returnsType();
    }

    public void resetState() {
        super.resetState();
        this.expression.resetState();
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            Predicate pred = (Predicate)i.next();
            pred.resetState();
        }
    }

    public void setPrimaryAxis(int axis) {
        this.expression.setPrimaryAxis(axis);
    }

    public int getDependencies() {
        int deps = 1;
        Iterator i = this.predicates.iterator();
        while (i.hasNext()) {
            deps |= ((Predicate)i.next()).getDependencies();
        }
        return deps;
    }
}

