/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.storage.DBBroker;
import org.exist.storage.UpdateListener;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.Module;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.value.AnyURIValue;

public class ModuleContext
extends XQueryContext {
    private final XQueryContext parentContext;
    private boolean initializing = true;

    public ModuleContext(XQueryContext parentContext) {
        super(parentContext.getAccessContext());
        this.parentContext = parentContext;
        this.broker = parentContext.broker;
        this.baseURI = parentContext.baseURI;
        this.moduleLoadPath = parentContext.moduleLoadPath;
        this.loadDefaults(this.broker.getConfiguration());
        this.initializing = false;
    }

    public XQueryContext copyContext() {
        ModuleContext ctx = new ModuleContext(this.parentContext);
        this.copyFields(ctx);
        return ctx;
    }

    public DocumentSet getStaticallyKnownDocuments() throws XPathException {
        return this.parentContext.getStaticallyKnownDocuments();
    }

    public Module getModule(String namespaceURI) {
        Module module = super.getModule(namespaceURI);
        if (module == null) {
            module = this.parentContext.getModule(namespaceURI);
        }
        return module;
    }

    public Module loadBuiltInModule(String namespaceURI, String moduleClass) {
        Module module = this.getModule(namespaceURI);
        if (module == null) {
            module = this.initBuiltInModule(namespaceURI, moduleClass);
        }
        if (module != null) {
            try {
                String defaultPrefix = module.getDefaultPrefix();
                if (!"".equals(defaultPrefix)) {
                    this.declareNamespace(defaultPrefix, module.getNamespaceURI());
                }
            }
            catch (XPathException e) {
                LOG.warn((Object)("error while loading builtin module class " + moduleClass), (Throwable)e);
            }
        }
        return module;
    }

    public Iterator getModules() {
        return this.parentContext.getModules();
    }

    public XQueryWatchDog getWatchDog() {
        return this.parentContext.getWatchDog();
    }

    public AnyURIValue getBaseURI() throws XPathException {
        return this.parentContext.getBaseURI();
    }

    public void setBaseURI(AnyURIValue uri) {
        this.parentContext.setBaseURI(uri);
    }

    public void setXQueryContextVar(String name, Object XQvar) {
        this.parentContext.setXQueryContextVar(name, XQvar);
    }

    public Object getXQueryContextVar(String name) {
        return this.parentContext.getXQueryContextVar(name);
    }

    public DBBroker getBroker() {
        return this.parentContext.getBroker();
    }

    public MemTreeBuilder getDocumentBuilder() {
        return this.parentContext.getDocumentBuilder();
    }

    public void pushDocumentContext() {
        this.parentContext.pushDocumentContext();
    }

    public LocalVariable markLocalVariables(boolean newContext) {
        return this.parentContext.markLocalVariables(newContext);
    }

    public void popLocalVariables(LocalVariable var) {
        this.parentContext.popLocalVariables(var);
    }

    public LocalVariable declareVariableBinding(LocalVariable var) throws XPathException {
        return this.parentContext.declareVariableBinding(var);
    }

    protected Variable resolveLocalVariable(QName qname) throws XPathException {
        return this.parentContext.resolveLocalVariable(qname);
    }

    public int getCurrentStackSize() {
        return this.parentContext.getCurrentStackSize();
    }

    public void popDocumentContext() {
        this.parentContext.popDocumentContext();
    }

    public String getURIForPrefix(String prefix) {
        String uri = this.getInScopeNamespace(prefix);
        if (uri != null) {
            return uri;
        }
        uri = this.getInheritedNamespace(prefix);
        if (uri != null) {
            return uri;
        }
        return (String)this.staticNamespaces.get(prefix);
    }

    public String getPrefixForURI(String uri) {
        String prefix = this.getInScopePrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.getInheritedPrefix(uri);
        if (prefix != null) {
            return prefix;
        }
        return (String)this.staticPrefixes.get(uri);
    }

    public String getInScopeNamespace(String prefix) {
        return this.parentContext.getInScopeNamespace(prefix);
    }

    public String getInScopePrefix(String uri) {
        return this.parentContext.getInScopePrefix(uri);
    }

    public String getInheritedNamespace(String prefix) {
        return this.parentContext.getInheritedNamespace(prefix);
    }

    public String getInheritedPrefix(String uri) {
        return this.parentContext.getInheritedPrefix(uri);
    }

    public void declareInScopeNamespace(String prefix, String uri) {
        this.parentContext.declareInScopeNamespace(prefix, uri);
    }

    public void pushInScopeNamespaces() {
        this.parentContext.pushInScopeNamespaces();
    }

    public void popInScopeNamespaces() {
        this.parentContext.popInScopeNamespaces();
    }

    public void registerUpdateListener(UpdateListener listener) {
        this.parentContext.registerUpdateListener(listener);
    }

    protected void clearUpdateListeners() {
    }
}

