/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.DefaultExpressionVisitor;
import org.exist.xquery.Expression;
import org.exist.xquery.ExtensionExpression;
import org.exist.xquery.Function;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.LocationStep;
import org.exist.xquery.OpAnd;
import org.exist.xquery.Optimizable;
import org.exist.xquery.Optimize;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Predicate;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.ExtFulltext;
import org.exist.xquery.util.ExpressionDumper;

public class Optimizer
extends DefaultExpressionVisitor {
    private static final Logger LOG = Logger.getLogger((Class)Optimizer.class);
    private XQueryContext context;
    private int predicates = 0;
    private boolean hasOptimized = false;

    public Optimizer(XQueryContext context) {
        this.context = context;
    }

    public boolean hasOptimized() {
        return this.hasOptimized;
    }

    public void visitLocationStep(LocationStep locationStep) {
        super.visitLocationStep(locationStep);
        boolean optimize = false;
        if (locationStep.hasPredicates()) {
            List preds = locationStep.getPredicates();
            Iterator i = preds.iterator();
            while (i.hasNext()) {
                Predicate pred = (Predicate)i.next();
                FindOptimizable find = new FindOptimizable();
                pred.accept(find);
                List list = find.getOptimizables();
                if (list.size() <= 0 || !this.canOptimize(list)) continue;
                optimize = true;
                break;
            }
        }
        if (optimize) {
            Expression parent = locationStep.getParent();
            if (!(parent instanceof PathExpr)) {
                LOG.warn((Object)("Parent expression of step is not a PathExpr: " + parent));
                return;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Rewriting expression: " + ExpressionDumper.dump(locationStep)));
            }
            this.hasOptimized = true;
            PathExpr path = (PathExpr)parent;
            try {
                ExtensionExpression extension = new ExtensionExpression(this.context);
                extension.addPragma(new Optimize(this.context, Optimize.OPTIMIZE_PRAGMA, null, false));
                extension.setExpression(locationStep);
                path.replaceExpression(locationStep, extension);
            }
            catch (XPathException e) {
                LOG.warn((Object)("Failed to optimize expression: " + locationStep + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void visitAndExpr(OpAnd and) {
        if (this.predicates > 0) {
            PathExpr path;
            Predicate predicate;
            Expression parent = and.getParent();
            if (!(parent instanceof PathExpr)) {
                LOG.warn((Object)("Parent expression of boolean operator is not a PathExpr: " + parent));
                return;
            }
            if (parent instanceof Predicate) {
                predicate = (Predicate)parent;
                path = predicate;
            } else {
                path = (PathExpr)parent;
                if (!((parent = path.getParent()) instanceof Predicate) || path.getLength() > 1) {
                    LOG.warn((Object)("Boolean operator is not a top-level expression in the predicate: " + parent.getClass().getName()));
                    return;
                }
                predicate = (Predicate)parent;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Rewriting boolean expression: " + ExpressionDumper.dump(and)));
            }
            this.hasOptimized = true;
            LocationStep step = (LocationStep)predicate.getParent();
            Predicate newPred = new Predicate(this.context);
            newPred.add(and.getRight());
            step.insertPredicate(predicate, newPred);
            path.replaceExpression(and, and.getLeft());
        }
    }

    public void visitPredicate(Predicate predicate) {
        ++this.predicates;
        super.visitPredicate(predicate);
        --this.predicates;
    }

    private boolean canOptimize(List list) {
        for (int j = 0; j < list.size(); ++j) {
            Optimizable optimizable = (Optimizable)list.get(j);
            int axis = optimizable.getOptimizeAxis();
            if (axis == 5 || axis == 7 || axis == 8 || axis == 6) continue;
            return false;
        }
        return true;
    }

    private class FindOptimizable
    extends BasicExpressionVisitor {
        List optimizables = new ArrayList();

        private FindOptimizable() {
        }

        public List getOptimizables() {
            return this.optimizables;
        }

        public void visitPathExpr(PathExpr expression) {
            for (int i = 0; i < expression.getLength(); ++i) {
                Expression next = expression.getExpression(i);
                next.accept(this);
            }
        }

        public void visitFtExpression(ExtFulltext fulltext) {
            this.optimizables.add(fulltext);
        }

        public void visitGeneralComparison(GeneralComparison comparison) {
            this.optimizables.add(comparison);
        }

        public void visitPredicate(Predicate predicate) {
            predicate.getExpression(0).accept(this);
        }

        public void visitBuiltinFunction(Function function) {
            if (function instanceof Optimizable) {
                this.optimizables.add(function);
            }
        }
    }
}

