/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BindingExpression;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.GroupSpec;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.GroupedValueSequenceTable;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public class QuantifiedExpression
extends BindingExpression {
    public static final int SOME = 0;
    public static final int EVERY = 1;
    private final int mode;

    public QuantifiedExpression(XQueryContext context, int mode) {
        super(context);
        switch (mode) {
            case 0: 
            case 1: {
                this.mode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException("QuantifiedExpression");
            }
        }
    }

    public void analyze(AnalyzeContextInfo contextInfo, OrderSpec[] orderBy, GroupSpec[] groupBy) throws XPathException {
        LocalVariable mark = this.context.markLocalVariables(false);
        this.context.declareVariableBinding(new LocalVariable(QName.parse(this.context, this.varName, null)));
        contextInfo.setParent(this);
        this.inputSequence.analyze(contextInfo);
        this.returnExpr.analyze(contextInfo);
        this.context.popLocalVariables(mark);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem, Sequence resultSequence, GroupedValueSequenceTable groupedSequence) throws XPathException {
        BooleanValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
            if (resultSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "RESULT SEQUENCE", resultSequence);
            }
        }
        LocalVariable var = new LocalVariable(QName.parse(this.context, this.varName, null));
        Sequence inSeq = this.inputSequence.eval(contextSequence, contextItem);
        if (this.sequenceType != null && !inSeq.isEmpty() && !Type.subTypeOf(inSeq.getItemType(), this.sequenceType.getPrimaryType())) {
            throw new XPathException("XPTY0004: Invalid type for variable $" + this.varName + ". Expected " + Type.getTypeName(this.sequenceType.getPrimaryType()) + ", got " + Type.getTypeName(inSeq.getItemType()));
        }
        boolean found = this.mode == 1;
        boolean canDecide = this.mode == 1;
        SequenceIterator i = inSeq.iterate();
        while (i.hasNext()) {
            canDecide = true;
            Item item = i.nextItem();
            var.setValue(item.toSequence());
            if (this.sequenceType == null) {
                var.checkType();
            }
            LocalVariable mark = this.context.markLocalVariables(false);
            this.context.declareVariableBinding(var);
            Sequence satisfiesSeq = this.returnExpr.eval(contextSequence, contextItem);
            this.context.popLocalVariables(mark);
            if (this.sequenceType != null) {
                if (!Type.subTypeOf(this.sequenceType.getPrimaryType(), -1)) {
                    if (!Type.subTypeOf(item.toSequence().getItemType(), this.sequenceType.getPrimaryType())) {
                        throw new XPathException("XPTY0004: Invalid type for variable $" + this.varName + ". Expected " + Type.getTypeName(this.sequenceType.getPrimaryType()) + ", got " + Type.getTypeName(contextItem.toSequence().getItemType()));
                    }
                } else {
                    if (!Type.subTypeOf(item.getType(), -1)) {
                        throw new XPathException("XPTY0004: Invalid type for variable $" + this.varName + ". Expected " + Type.getTypeName(-1) + " (or more specific), got " + Type.getTypeName(item.getType()));
                    }
                    var.checkType();
                }
            }
            found = satisfiesSeq.effectiveBooleanValue();
            if ((this.mode != 0 || !found) && (this.mode != 1 || found)) continue;
            break;
        }
        BooleanValue booleanValue = result = canDecide && found ? BooleanValue.TRUE : BooleanValue.FALSE;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display(this.mode == 0 ? "some" : "every");
        dumper.display(" $").display(this.varName).display(" in");
        dumper.startIndent();
        this.inputSequence.dump(dumper);
        dumper.endIndent().nl();
        dumper.display("satisfies");
        dumper.startIndent();
        this.returnExpr.dump(dumper);
        dumper.endIndent();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.mode == 0 ? "some" : "every");
        result.append(" $").append(this.varName).append(" in");
        result.append(" ");
        result.append(this.inputSequence.toString());
        result.append(" ");
        result.append("satisfies");
        result.append(" ");
        result.append(this.returnExpr.toString());
        result.append(" ");
        return result.toString();
    }

    public int returnsType() {
        return 23;
    }

    public int getDependencies() {
        return 3;
    }
}

