/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.ValueSequence;

public class SequenceConstructor
extends PathExpr {
    public SequenceConstructor(XQueryContext context) {
        super(context);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        this.contextId = contextInfo.getContextId();
        for (int i = 0; i < this.steps.size(); ++i) {
            Expression expr = (Expression)this.steps.get(i);
            expr.analyze(new AnalyzeContextInfo(contextInfo));
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        ValueSequence result = new ValueSequence();
        Iterator i = this.steps.iterator();
        while (i.hasNext()) {
            Sequence temp = ((Expression)i.next()).eval(contextSequence, contextItem);
            if (temp == null || temp.isEmpty()) continue;
            result.addAll(temp);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("(");
        dumper.startIndent();
        boolean moreThanOne = false;
        Iterator i = this.steps.iterator();
        while (i.hasNext()) {
            if (moreThanOne) {
                dumper.display(", ");
            }
            moreThanOne = true;
            ((Expression)i.next()).dump(dumper);
        }
        dumper.endIndent();
        dumper.nl().display(")");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("( ");
        boolean moreThanOne = false;
        Iterator i = this.steps.iterator();
        while (i.hasNext()) {
            if (moreThanOne) {
                result.append(", ");
            }
            moreThanOne = true;
            result.append(((Expression)i.next()).toString());
        }
        result.append(" )");
        return result.toString();
    }

    public int returnsType() {
        return 11;
    }

    public int getCardinality() {
        return 7;
    }

    public void resetState() {
        super.resetState();
    }
}

