/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;

public class TextConstructor
extends NodeConstructor {
    private final String text;
    private boolean isWhitespaceOnly = true;

    public TextConstructor(XQueryContext context, String text) throws XPathException {
        super(context);
        this.text = StringValue.expand(text);
        for (int i = 0; i < text.length(); ++i) {
            if (TextConstructor.isWhiteSpace(text.charAt(i))) continue;
            this.isWhitespaceOnly = false;
            break;
        }
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.isWhitespaceOnly && this.context.stripWhitespace()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        this.context.proceed(this, builder);
        int nodeNr = builder.characters(this.text);
        NodeImpl node = builder.getDocument().getNode(nodeNr);
        return node;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("text {");
        dumper.startIndent();
        dumper.display(this.text);
        dumper.endIndent();
        dumper.nl().display("}");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("text {");
        result.append(this.text.toString());
        result.append("}");
        return result.toString();
    }

    protected static final boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }
}

