/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.DynamicTypeCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class TreatAsExpression
extends AbstractExpression {
    private Expression expression;
    private SequenceType type;

    public TreatAsExpression(XQueryContext context, Expression expr, SequenceType type) {
        super(context);
        this.expression = expr;
        this.type = type;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        return this.expression.eval(contextSequence, contextItem);
    }

    public int returnsType() {
        return this.type.getPrimaryType();
    }

    public int getCardinality() {
        return this.type.getCardinality();
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
        this.expression = new DynamicCardinalityCheck(this.context, this.type.getCardinality(), this.expression, new Error("XPDY0050", this.type.toString()));
        this.expression = new DynamicTypeCheck(this.context, this.type.getPrimaryType(), this.expression);
    }

    public void dump(ExpressionDumper dumper) {
        this.expression.dump(dumper);
        dumper.display(" treat as ");
        dumper.display(this.type.toString());
    }

    public void resetState() {
        super.resetState();
        this.expression.resetState();
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }
}

