/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.dom.DocumentSet;
import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Expression;
import org.exist.xquery.LocalVariable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class TypeswitchExpression
extends AbstractExpression {
    private Expression operand;
    private Case defaultClause = null;
    private List cases = new ArrayList(5);

    public TypeswitchExpression(XQueryContext context, Expression operand) {
        super(context);
        this.operand = operand;
    }

    public void addCase(SequenceType type, QName var, Expression caseClause) {
        this.cases.add(new Case(type, var, caseClause));
    }

    public void setDefault(QName var, Expression defaultClause) {
        this.defaultClause = new Case(null, var, defaultClause);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        Sequence opSeq = this.operand.eval(contextSequence);
        Sequence result = null;
        LocalVariable mark = this.context.markLocalVariables(false);
        for (int i = 0; i < this.cases.size(); ++i) {
            Case next = (Case)this.cases.get(i);
            if (!this.checkType(next.type, opSeq)) continue;
            if (next.variable != null) {
                LocalVariable var = new LocalVariable(next.variable);
                var.setSequenceType(next.type);
                var.setValue(opSeq);
                var.setContextDocs(this.operand.getContextDocSet());
                var.checkType();
                this.context.declareVariableBinding(var);
            }
            result = next.returnClause.eval(contextSequence);
            break;
        }
        if (result == null) {
            if (this.defaultClause.variable != null) {
                LocalVariable var = new LocalVariable(this.defaultClause.variable);
                var.setValue(opSeq);
                var.setContextDocs(this.operand.getContextDocSet());
                this.context.declareVariableBinding(var);
            }
            result = this.defaultClause.returnClause.eval(contextSequence);
        }
        this.context.popLocalVariables(mark);
        return result;
    }

    private boolean checkType(SequenceType type, Sequence seq) throws XPathException {
        int actualCardinality;
        int requiredCardinality = type.getCardinality();
        if (!Cardinality.checkCardinality(requiredCardinality, actualCardinality = seq.isEmpty() ? 1 : (seq.hasMany() ? 4 : 2))) {
            return false;
        }
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (type.checkType(next)) continue;
            return false;
        }
        return true;
    }

    public int returnsType() {
        return this.operand.returnsType();
    }

    public int getDependencies() {
        return 3;
    }

    public int getCardinality() {
        return 7;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.operand.analyze(contextInfo);
        LocalVariable mark0 = this.context.markLocalVariables(false);
        for (int i = 0; i < this.cases.size(); ++i) {
            LocalVariable mark1 = this.context.markLocalVariables(false);
            Case next = (Case)this.cases.get(i);
            if (next.variable != null) {
                LocalVariable var = new LocalVariable(next.variable);
                var.setSequenceType(next.type);
                this.context.declareVariableBinding(var);
            }
            next.returnClause.analyze(contextInfo);
            this.context.popLocalVariables(mark1);
        }
        if (this.defaultClause.variable != null) {
            LocalVariable var = new LocalVariable(this.defaultClause.variable);
            this.context.declareVariableBinding(var);
        }
        this.defaultClause.returnClause.analyze(contextInfo);
        this.context.popLocalVariables(mark0);
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.operand.setContextDocSet(contextSet);
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("typeswitch(", this.getASTNode());
        this.operand.dump(dumper);
        dumper.display(')');
        dumper.startIndent();
        for (int i = 0; i < this.cases.size(); ++i) {
            Case caseClause = (Case)this.cases.get(i);
            dumper.display("case ");
            dumper.display(caseClause.type);
            if (caseClause.variable != null) {
                dumper.display('$');
                dumper.display(caseClause.variable.getStringValue());
                dumper.display(" as ");
            }
            dumper.display(" return ");
            dumper.display(caseClause.returnClause).nl();
        }
        dumper.display("default ");
        if (this.defaultClause.variable != null) {
            dumper.display('$');
            dumper.display(this.defaultClause.variable.getStringValue());
            dumper.display(' ');
        }
        this.defaultClause.returnClause.dump(dumper);
        dumper.endIndent();
    }

    public void resetState() {
        super.resetState();
        this.operand.resetState();
        this.defaultClause.returnClause.resetState();
        for (int i = 0; i < this.cases.size(); ++i) {
            Case caseClause = (Case)this.cases.get(i);
            caseClause.returnClause.resetState();
        }
    }

    private class Case {
        SequenceType type;
        Expression returnClause;
        QName variable;

        public Case(SequenceType type, QName variable, Expression caseClause) {
            this.type = type;
            this.variable = variable;
            this.returnClause = caseClause;
        }
    }
}

