/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Module;
import org.exist.xquery.Profiler;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class VariableDeclaration
extends AbstractExpression {
    String qname;
    SequenceType sequenceType = null;
    Expression expression;
    boolean analyzeDone = false;

    public VariableDeclaration(XQueryContext context, String qname, Expression expr) {
        super(context);
        this.qname = qname;
        this.expression = expr;
    }

    public void setSequenceType(SequenceType type) {
        this.sequenceType = type;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        QName qn = QName.parse(this.context, this.qname, null);
        Variable var = new Variable(qn);
        var.setIsInitialized(false);
        if (!this.analyzeDone) {
            Module myModule = this.context.getModule(qn.getNamespaceURI());
            if (myModule != null) {
                if (myModule.isVarDeclared(qn)) {
                    throw new XPathException(this.getASTNode(), "err:XQST0049: It is a static error if more than one variable declared or imported by a module has the same expanded QName. Variable: " + qn);
                }
                myModule.declareVariable(var);
            } else {
                if (this.context.isVarDeclared(qn)) {
                    throw new XPathException(this.getASTNode(), "err:XQST0049: It is a static error if more than one variable declared or imported by a module has the same expanded QName. Variable: " + qn);
                }
                this.context.declareGlobalVariable(var);
            }
            this.analyzeDone = true;
        }
        this.expression.analyze(contextInfo);
        var.setIsInitialized(true);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        QName qn = QName.parse(this.context, this.qname, null);
        Module myModule = this.context.getModule(qn.getNamespaceURI());
        this.context.pushDocumentContext();
        Sequence seq = this.expression.eval(null, null);
        if (myModule != null) {
            Variable var = myModule.declareVariable(qn, seq);
            var.setSequenceType(this.sequenceType);
            var.checkType();
        } else {
            Variable var = new Variable(qn);
            var.setValue(seq);
            var.setSequenceType(this.sequenceType);
            var.checkType();
            this.context.declareGlobalVariable(var);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", seq);
        }
        this.context.popDocumentContext();
        return Sequence.EMPTY_SEQUENCE;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.nl().display("declare variable $").display(this.qname, this.getASTNode());
        if (this.sequenceType != null) {
            dumper.display(" as ").display(this.sequenceType.toString());
        }
        dumper.display("{");
        dumper.startIndent();
        this.expression.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("}").nl();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("declare variable $").append(this.qname);
        if (this.sequenceType != null) {
            result.append(" as ").append(this.sequenceType.toString());
        }
        result.append("{");
        result.append(this.expression.toString());
        result.append("}");
        return result.toString();
    }

    public int returnsType() {
        return this.expression.returnsType();
    }

    public int getDependencies() {
        return 1;
    }

    public int getCardinality() {
        return this.expression.getCardinality();
    }

    public void resetState() {
        super.resetState();
        this.expression.resetState();
        this.analyzeDone = false;
    }
}

