/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import com.sun.xacml.ctx.RequestCtx;
import java.io.IOException;
import java.io.Reader;
import java.text.NumberFormat;
import org.apache.log4j.Logger;
import org.exist.security.PermissionDeniedException;
import org.exist.security.xacml.AccessContext;
import org.exist.security.xacml.ExistPDP;
import org.exist.security.xacml.XACMLSource;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Optimizer;
import org.exist.xquery.PathExpr;
import org.exist.xquery.StaticXQueryException;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.HTTPUtils;
import org.exist.xquery.value.Sequence;

public class XQuery {
    private static final Logger LOG = Logger.getLogger((Class)XQuery.class);
    private DBBroker broker;

    public XQuery(DBBroker broker) {
        this.broker = broker;
    }

    public XQueryContext newContext(AccessContext accessCtx) {
        return new XQueryContext(this.broker, accessCtx);
    }

    public XQueryPool getXQueryPool() {
        return this.broker.getBrokerPool().getXQueryPool();
    }

    public CompiledXQuery compile(XQueryContext context, String expression) throws XPathException {
        StringSource source = new StringSource(expression);
        try {
            return this.compile(context, source);
        }
        catch (IOException ioe) {
            throw new XPathException(ioe.getMessage(), ioe);
        }
    }

    public CompiledXQuery compile(XQueryContext context, Source source) throws XPathException, IOException {
        return this.compile(context, source, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompiledXQuery compile(XQueryContext context, Source source, boolean xpointer) throws XPathException, IOException {
        XACMLSource xsource = XACMLSource.getInstance(source);
        Reader reader = source.getReader();
        try {
            CompiledXQuery compiled = this.compile(context, reader, xpointer);
            compiled.setSource(xsource);
            CompiledXQuery compiledXQuery = compiled;
            return compiledXQuery;
        }
        finally {
            reader.close();
        }
    }

    private CompiledXQuery compile(XQueryContext context, Reader reader, boolean xpointer) throws XPathException {
        long start = System.currentTimeMillis();
        XQueryLexer lexer = new XQueryLexer(context, reader);
        XQueryParser parser = new XQueryParser(lexer);
        XQueryTreeParser treeParser = new XQueryTreeParser(context);
        try {
            if (xpointer) {
                parser.xpointer();
            } else {
                parser.xpath();
            }
            if (parser.foundErrors()) {
                LOG.debug((Object)parser.getErrorMessage());
                throw new StaticXQueryException(parser.getErrorMessage());
            }
            AST ast = parser.getAST();
            if (ast == null) {
                throw new XPathException("Unknown XQuery parser error: the parser returned an empty syntax tree.");
            }
            PathExpr expr = new PathExpr(context);
            if (xpointer) {
                treeParser.xpointer(ast, expr);
            } else {
                treeParser.xpath(ast, expr);
            }
            if (treeParser.foundErrors()) {
                throw new StaticXQueryException(treeParser.getErrorMessage(), treeParser.getLastException());
            }
            expr.analyze(new AnalyzeContextInfo());
            if (context.optimizationsEnabled()) {
                Optimizer optimizer = new Optimizer(context);
                expr.accept(optimizer);
                if (optimizer.hasOptimized()) {
                    context.reset(true);
                    expr.analyze(new AnalyzeContextInfo());
                }
            }
            if (context.getExpressionCount() < 150) {
                LOG.debug((Object)("Query diagnostics:\n" + ExpressionDumper.dump(expr)));
            } else {
                LOG.debug((Object)"Query diagnostics:\n[skipped: more than 150 expressions]");
            }
            if (LOG.isDebugEnabled()) {
                NumberFormat nf = NumberFormat.getNumberInstance();
                LOG.debug((Object)("Compilation took " + nf.format(System.currentTimeMillis() - start) + " ms"));
            }
            return expr;
        }
        catch (RecognitionException e) {
            LOG.debug((Object)("Error compiling query: " + e.getMessage()), (Throwable)e);
            String msg = e.getMessage();
            if (msg.endsWith(", found 'null'")) {
                msg = msg.substring(0, msg.length() - ", found 'null'".length());
            }
            throw new StaticXQueryException(msg, e.getLine(), e.getColumn());
        }
        catch (TokenStreamException e) {
            LOG.debug((Object)("Error compiling query: " + e.getMessage()), (Throwable)e);
            throw new StaticXQueryException(e.getMessage(), e);
        }
    }

    public Sequence execute(CompiledXQuery expression, Sequence contextSequence) throws XPathException {
        XQueryContext context = expression.getContext();
        Sequence result = this.execute(expression, contextSequence, true);
        HTTPUtils.addLastModifiedHeader(result, context);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sequence execute(CompiledXQuery expression, Sequence contextSequence, boolean resetContext) throws XPathException {
        long start = System.currentTimeMillis();
        XQueryContext context = expression.getContext();
        XACMLSource source = expression.getSource();
        try {
            ExistPDP pdp = context.getPDP();
            if (pdp != null) {
                RequestCtx request = pdp.getRequestHelper().createQueryRequest(context, source);
                pdp.evaluate(request);
            }
        }
        catch (PermissionDeniedException pde) {
            throw new XPathException("Permission to execute query: " + source.createId() + " denied.", pde);
        }
        expression.reset();
        if (resetContext) {
            context.setBroker(this.broker);
            context.getWatchDog().reset();
        }
        context.prepare();
        this.broker.getBrokerPool().getXQueryMonitor().queryStarted(context.getWatchDog());
        try {
            Sequence result = expression.eval(contextSequence);
            if (LOG.isDebugEnabled()) {
                NumberFormat nf = NumberFormat.getNumberInstance();
                LOG.debug((Object)("Execution took " + nf.format(System.currentTimeMillis() - start) + " ms"));
            }
            Sequence sequence = result;
            return sequence;
        }
        finally {
            expression.reset();
            if (resetContext) {
                context.reset();
            }
            this.broker.getBrokerPool().getXQueryMonitor().queryCompleted(context.getWatchDog());
        }
    }

    public Sequence execute(String expression, Sequence contextSequence, AccessContext accessCtx) throws XPathException {
        XQueryContext context = new XQueryContext(this.broker, accessCtx);
        CompiledXQuery compiled = this.compile(context, expression);
        return this.execute(compiled, null);
    }
}

