/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.Iterator;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.numbering.NodeId;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class ExtDoctype
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("doctype", "http://www.w3.org/2005/xpath-functions"), "Returns the document nodes of the documents whose DOCTYPE is given by $a.", new SequenceType[]{new SequenceType(22, 6)}, new SequenceType(-1, 7), "This function is eXist-specific and should not be in the standard functions namespace. Please use util:doctype instead.");

    public ExtDoctype(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        DocumentSet docs = new DocumentSet();
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            Sequence seq = this.getArgument(i).eval(contextSequence, contextItem);
            SequenceIterator j = seq.iterate();
            while (j.hasNext()) {
                String next = j.nextItem().getStringValue();
                this.context.getBroker().getXMLResourcesByDoctype(next, docs);
            }
        }
        ExtArrayNodeSet result = new ExtArrayNodeSet(1);
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            result.add(new NodeProxy((DocumentImpl)i.next(), NodeId.DOCUMENT_NODE));
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

