/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;

public class FunAvg
extends Function {
    private boolean gotInfinity = false;
    public static final FunctionSignature signature = new FunctionSignature(new QName("avg", "http://www.w3.org/2005/xpath-functions"), "Returns the average of the values in the input sequence $a, that is, the sum of the values divided by the number of values.", new SequenceType[]{new SequenceType(20, 7)}, new SequenceType(20, 3));

    public FunAvg(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence inner;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((inner = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            SequenceIterator iter = inner.iterate();
            Item item = iter.nextItem();
            AtomicValue value = item.atomize();
            if (value.getType() == 21) {
                value = value.convertTo(34);
            }
            if (!(value instanceof ComputableValue)) {
                throw new XPathException("XPTY0004: '" + Type.getTypeName(value.getType()) + "(" + value + ")' can not be an operand in a sum");
            }
            ComputableValue sum = (ComputableValue)value;
            while (iter.hasNext()) {
                item = iter.nextItem();
                value = item.atomize();
                if (value.getType() == 21) {
                    value = value.convertTo(34);
                }
                if (!(value instanceof ComputableValue)) {
                    throw new XPathException("XPTY0004: '" + Type.getTypeName(value.getType()) + "(" + value + ")' can not be an operand in a sum");
                }
                if (Type.subTypeOf(value.getType(), 30)) {
                    if (((NumericValue)value).isInfinite()) {
                        this.gotInfinity = true;
                    }
                    if (((NumericValue)value).isNaN()) {
                        sum = DoubleValue.NaN;
                        break;
                    }
                }
                try {
                    sum = (ComputableValue)sum.promote(value);
                    sum = sum.plus((ComputableValue)value);
                }
                catch (XPathException e) {
                    throw new XPathException("FORG0006: " + e.getMessage(), e);
                }
            }
            result = sum.div(new IntegerValue(inner.getItemCount()));
        }
        if (this.gotInfinity || !Type.subTypeOf(result.getItemType(), 30) || ((NumericValue)result).isInfinite()) {
            // empty if block
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

