/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class FunError
extends BasicFunction {
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("error", "http://www.w3.org/2005/xpath-functions"), "Indicates that an irrecoverable error has occurred. The script will terminate immediately with an exception.", null, new SequenceType(10, 1)), new FunctionSignature(new QName("error", "http://www.w3.org/2005/xpath-functions"), "Indicates that an irrecoverable error has occurred. The script will terminate immediately with an exception.", new SequenceType[]{new SequenceType(24, 2)}, new SequenceType(10, 1)), new FunctionSignature(new QName("error", "http://www.w3.org/2005/xpath-functions"), "Indicates that an irrecoverable error has occurred. The script will terminate immediately with an exception.", new SequenceType[]{new SequenceType(24, 3), new SequenceType(22, 2)}, new SequenceType(10, 1)), new FunctionSignature(new QName("error", "http://www.w3.org/2005/xpath-functions"), "Indicates that an irrecoverable error has occurred. The script will terminate immediately with an exception.", new SequenceType[]{new SequenceType(24, 3), new SequenceType(22, 2), new SequenceType(11, 7)}, new SequenceType(10, 1))};
    public static final QName DEFAULT_ERR = new QName("FOER0000", "http://www.w3.org/2004/07/xqt-errors", "err");

    public FunError(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public int returnsType() {
        return 10;
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        QName errQName = DEFAULT_ERR;
        String message = "An error has been raised by the query";
        if (args.length > 0) {
            if (!args[0].isEmpty()) {
                errQName = ((QNameValue)args[0].itemAt(0)).getQName();
            }
            if (args.length > 1) {
                message = args[1].getStringValue();
            }
            if (args.length == 3) {
                message = message + ": " + this.serializeErrorObject(args[2]);
            }
        }
        throw new XPathException(this.getASTNode(), message + " (" + errQName.getNamespaceURI() + '#' + errQName.getLocalName() + ')');
    }

    private String serializeErrorObject(Sequence seq) throws XPathException {
        StringBuffer buf = new StringBuffer();
        SequenceIterator i = seq.unorderedIterator();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (Type.subTypeOf(next.getType(), -1)) {
                Serializer serializer = this.context.getBroker().getSerializer();
                serializer.reset();
                try {
                    buf.append(serializer.serialize((NodeValue)next));
                    continue;
                }
                catch (SAXException e) {
                    throw new XPathException(this.getASTNode(), "An exception occurred while serializing node to log: e.getMessage()", e);
                }
            }
            buf.append(next.getStringValue());
        }
        return buf.toString();
    }
}

