/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.Iterator;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.memtree.ElementImpl;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.EmptySequence;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Element;

public class FunResolveQName
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("resolve-QName", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:QName value (that is, an expanded-QName) by taking an xs:string that has the lexical form of an xs:QName (a string in the form \"prefix:local-name\" or \"local-name\") and resolving it using the in-scope namespaces for a given element.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(1, 2)}, new SequenceType(24, 2));

    public FunResolveQName(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence qnameSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if ((qnameSeq = args[0]).isEmpty()) {
            return EmptySequence.EMPTY_SEQUENCE;
        }
        this.context.pushInScopeNamespaces();
        String qnameString = args[0].getStringValue();
        if (QName.isQName(qnameString)) {
            String prefix = QName.extractPrefix(qnameString);
            if (prefix == null) {
                prefix = "";
            }
            String uri = null;
            NodeValue node = (NodeValue)args[1].itemAt(0);
            if (node.getImplementationType() == 1) {
                org.exist.dom.ElementImpl e;
                NodeProxy proxy = (NodeProxy)node;
                NodeSet ancestors = proxy.getAncestors(this.contextId, true);
                NodeSetIterator i = ancestors.iterator();
                while (i.hasNext() && (uri = this.findNamespaceURI(e = (org.exist.dom.ElementImpl)(proxy = (NodeProxy)i.next()).getNode(), prefix)) == null) {
                }
            } else {
                NodeImpl next = (NodeImpl)node;
                while ((uri = FunResolveQName.findNamespaceURI((ElementImpl)next, prefix)) == null && (next = (NodeImpl)next.getParentNode()) != null && next.getNodeType() == 1) {
                }
            }
            if (uri == null && prefix != null && !"".equals(prefix)) {
                throw new XPathException(this.getASTNode(), "No namespace found for prefix. No binding for prefix '" + prefix + "' was found. err:FONS0004");
            }
            String localPart = QName.extractLocalName(qnameString);
            QName qn = new QName(localPart, uri);
            qn.setPrefix(prefix);
            QNameValue result = new QNameValue(this.context, qn);
            if (this.context.getProfiler().isEnabled()) {
                this.context.getProfiler().end(this, "", result);
            }
            this.context.popInScopeNamespaces();
            return result;
        }
        throw new XPathException(this.getASTNode(), "Invalid lexical value. '" + qnameString + "' is not a QName. err:FOCA0002");
    }

    public String findNamespaceURI(org.exist.dom.ElementImpl element, String prefix) {
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0 && prefix.equals(element.getPrefix())) {
            return namespaceURI;
        }
        if (element.declaresNamespacePrefixes()) {
            Iterator i = element.getPrefixes();
            while (i.hasNext()) {
                String elementPrefix = (String)i.next();
                this.context.declareInScopeNamespace(elementPrefix, element.getNamespaceForPrefix(elementPrefix));
                if (!prefix.equals(elementPrefix)) continue;
                return element.getNamespaceForPrefix(prefix);
            }
        }
        return null;
    }

    public static String findNamespaceURI(Element element, String prefix) {
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0 && prefix.equals(element.getPrefix())) {
            return namespaceURI;
        }
        return null;
    }

    public static String findNamespaceURI(ElementImpl element, String prefix) {
        String namespaceURI = element.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0 && prefix.equals(element.getPrefix())) {
            return namespaceURI;
        }
        if (element.declaresNamespacePrefixes()) {
            return (String)element.getNamespaceMap().get(prefix);
        }
        return null;
    }
}

