/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.net.URI;
import java.net.URISyntaxException;
import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunResolveURI
extends Function {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("resolve-uri", "http://www.w3.org/2005/xpath-functions"), "The purpose of this function is to enable a relative URI $a to be resolved against the static context's base URI.", new SequenceType[]{new SequenceType(22, 3)}, new SequenceType(25, 3)), new FunctionSignature(new QName("resolve-uri", "http://www.w3.org/2005/xpath-functions"), "The purpose of this function is to enable a relative URI $a to be resolved against the absolute URI $b. If $a is the empty sequence, the empty sequence is returned.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(22, 2)}, new SequenceType(25, 3))};

    public FunResolveURI(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        AnyURIValue base;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.getArgumentCount() == 1) {
            if (!this.context.isBaseURIDeclared()) {
                throw new XPathException("err:FONS0005: base URI of the static context has not been assigned a value.");
            }
            base = this.context.getBaseURI();
        } else {
            try {
                AtomicValue item = this.getArgument(1).eval(contextSequence).itemAt(0).convertTo(25);
                base = (AnyURIValue)item;
            }
            catch (XPathException e) {
                throw new XPathException(this.getASTNode(), "err:FORG0002: invalid argument to fn:resolve-uri(): " + e.getMessage(), e);
            }
        }
        Sequence seq = this.getArgument(0).eval(contextSequence);
        if (seq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            URI baseURI;
            URI relativeURI;
            AnyURIValue relative;
            try {
                AtomicValue item = seq.itemAt(0).convertTo(25);
                relative = (AnyURIValue)item;
            }
            catch (XPathException e) {
                throw new XPathException(this.getASTNode(), "err:FORG0002: invalid argument to fn:resolve-uri(): " + e.getMessage(), e);
            }
            try {
                relativeURI = new URI(relative.getStringValue());
                baseURI = new URI(base.getStringValue() + "/");
            }
            catch (URISyntaxException e) {
                throw new XPathException(this.getASTNode(), "err:FORG0009: unable to resolve a relative URI against a base URI in fn:resolve-uri(): " + e.getMessage(), e);
            }
            result = relativeURI.isAbsolute() ? relative : new AnyURIValue(baseURI.resolve(relativeURI));
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

