/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunStringPad
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("string-pad", "http://www.w3.org/2005/xpath-functions"), "Returns an xs:string consisting of a number copies of the first argument concatenated together without any separators. The number of copies is specified by the second argument.", new SequenceType[]{new SequenceType(22, 3), new SequenceType(31, 2)}, new SequenceType(22, 3));

    public FunStringPad(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence result;
        Sequence seq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if ((seq = this.getArgument(0).eval(contextSequence, contextItem)).isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            String str = seq.getStringValue();
            int count = ((IntegerValue)this.getArgument(1).eval(contextSequence, contextItem).convertTo(31)).getInt();
            if (count < 0) {
                throw new XPathException("Invalid string-pad count");
            }
            if (count == 0) {
                result = StringValue.EMPTY_STRING;
            } else {
                StringBuffer buf = new StringBuffer(str.length() * count);
                for (int i = 0; i < count; ++i) {
                    buf.append(str);
                }
                result = new StringValue(buf.toString());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

