/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import org.exist.dom.QName;
import org.exist.http.servlets.SessionWrapper;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.session.SessionModule;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class GetID
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("get-id", "http://exist-db.org/xquery/session", "session"), "Returns the ID of the current session or an empty sequence if there is no session.", null, new SequenceType(22, 3));
    public static final FunctionSignature deprecated = new FunctionSignature(new QName("get-session-id", "http://exist-db.org/xquery/request", "request"), "Returns the ID of the current session or an empty sequence if there is no session.", null, new SequenceType(22, 3), "Moved to session module and renamed to session:get-id.");

    public GetID(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        SessionModule myModule = (SessionModule)this.context.getModule("http://exist-db.org/xquery/session");
        Variable var = myModule.resolveVariable(SessionModule.SESSION_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException("Session not set");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException("Variable $session is not bound to an Java object.");
        }
        JavaObjectValue session = (JavaObjectValue)var.getValue().itemAt(0);
        if (session.getObject() instanceof SessionWrapper) {
            String id = ((SessionWrapper)session.getObject()).getId();
            if (id == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            return new StringValue(id);
        }
        throw new XPathException("Type error: variable $request is not bound to a request object");
    }
}

