/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.session;

import org.exist.dom.QName;
import org.exist.http.servlets.SessionWrapper;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.session.SessionModule;
import org.exist.xquery.value.JavaObjectValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Invalidate
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("invalidate", "http://exist-db.org/xquery/session", "session"), "Invalidate (remove) the current HTTP session if present", null, new SequenceType(11, 1));
    public static final FunctionSignature deprecated = new FunctionSignature(new QName("invalidate-session", "http://exist-db.org/xquery/request", "request"), "Invalidate (remove) the current HTTP session if present", null, new SequenceType(11, 1), "Moved to 'session' module and renamed to session:invalidate");

    public Invalidate(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        SessionModule myModule = (SessionModule)this.context.getModule("http://exist-db.org/xquery/session");
        Variable var = myModule.resolveVariable(SessionModule.SESSION_VAR);
        if (var == null || var.getValue() == null) {
            throw new XPathException("Session not set");
        }
        if (var.getValue().getItemType() != 100) {
            throw new XPathException("Variable $session is not bound to an Java object.");
        }
        JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
        if (value.getObject() instanceof SessionWrapper) {
            SessionWrapper session = (SessionWrapper)value.getObject();
            session.invalidate();
            return Sequence.EMPTY_SEQUENCE;
        }
        throw new XPathException("Type error: variable $session is not bound to a session object");
    }
}

