/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.collections.Collection;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.storage.FulltextIndexSpec;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicExpressionVisitor;
import org.exist.xquery.CachedResult;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.LocationStep;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Optimizable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.RegexTranslator;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;

public class MatchRegexp
extends Function
implements Optimizable {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("match-all", "http://exist-db.org/xquery/text", "text"), "Tries to match each of the regular expression strings passed in $b against the keywords contained in the fulltext index. The keywords found are then compared to the node set in $a. Every node containing ALL of the keywords is copied to the result sequence. By default, a keyword is considered to match the pattern if any substring of the keyword matches. To change this behaviour, use the 3-argument version of the function and specify flag 'w'. With 'w' specified, the regular expression is matched against the entire keyword, i.e. 'explain.*' will match 'explained' , but not 'unexplained'.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 6)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("match-all", "http://exist-db.org/xquery/text", "text"), "Tries to match each of the regular expression strings passed in $b against the keywords contained in the fulltext index. The keywords found are then compared to the node set in $a. Every node containing ALL of the keywords is copied to the result sequence. By default, a keyword is considered to match the pattern if any substring of the keyword matches. To change this behaviour, use the 3-argument version of the function and specify flag 'w'. With 'w' specified, the regular expression is matched against the entire keyword, i.e. 'explain.*' will match 'explained' , but not 'unexplained'.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 6), new SequenceType(22, 2)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("match-any", "http://exist-db.org/xquery/text", "text"), "Tries to match each of the regular expression strings passed in $b against the keywords contained in the fulltext index. The keywords found are then compared to the node set in $a. Every node containing ANY of the keywords is copied to the result sequence. By default, a keyword is considered to match the pattern if any substring of the keyword matches. To change this behaviour, use the 3-argument version of the function and specify flag 'w'. With 'w' specified, the regular expression is matched against the entire keyword, i.e. 'explain.*' will match 'explained' , but not 'unexplained'.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 6)}, new SequenceType(-1, 7)), new FunctionSignature(new QName("match-any", "http://exist-db.org/xquery/text", "text"), "Tries to match each of the regular expression strings passed in $b against the keywords contained in the fulltext index. The keywords found are then compared to the node set in $a. Every node containing ANY of the keywords is copied to the result sequence. By default, a keyword is considered to match the pattern if any substring of the keyword matches. To change this behaviour, use the 3-argument version of the function and specify flag 'w'. With 'w' specified, the regular expression is matched against the entire keyword, i.e. 'explain.*' will match 'explained' , but not 'unexplained'.", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(22, 6), new SequenceType(22, 2)}, new SequenceType(-1, 7))};
    public static final String MATCH_ALL_FLAG = "w";
    protected int type = 1;
    protected CachedResult cached = null;
    private LocationStep contextStep = null;
    protected QName contextQName = null;
    protected int axis = -1;
    protected boolean optimizeSelf = false;
    protected NodeSet preselectResult = null;

    public MatchRegexp(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        List steps;
        super.analyze(contextInfo);
        if (this.isCalledAs("match-any")) {
            this.type = 0;
        }
        if (!(steps = BasicExpressionVisitor.findLocationSteps(this.getArgument(0))).isEmpty()) {
            LocationStep firstStep = (LocationStep)steps.get(0);
            LocationStep lastStep = (LocationStep)steps.get(steps.size() - 1);
            if (steps.size() == 1 && firstStep.getAxis() == 12) {
                LocationStep outerStep;
                NodeTest test;
                Expression outerExpr = contextInfo.getContextStep();
                if (outerExpr != null && outerExpr instanceof LocationStep && !(test = (outerStep = (LocationStep)outerExpr).getTest()).isWildcardTest() && test.getName() != null) {
                    this.contextQName = new QName(test.getName());
                    if (outerStep.getAxis() == 6 || outerStep.getAxis() == 13) {
                        this.contextQName.setNameType((byte)1);
                    }
                    this.contextStep = firstStep;
                    this.axis = outerStep.getAxis();
                    this.optimizeSelf = true;
                }
            } else {
                NodeTest test = lastStep.getTest();
                if (!test.isWildcardTest() && test.getName() != null) {
                    this.contextQName = new QName(test.getName());
                    if (lastStep.getAxis() == 6 || lastStep.getAxis() == 13) {
                        this.contextQName.setNameType((byte)1);
                    }
                    this.axis = firstStep.getAxis();
                    this.contextStep = lastStep;
                }
            }
        }
    }

    public boolean canOptimize(Sequence contextSequence) {
        if (this.contextQName == null) {
            return false;
        }
        return this.checkForQNameIndex(contextSequence);
    }

    public boolean optimizeOnSelf() {
        return this.optimizeSelf;
    }

    public int getOptimizeAxis() {
        return this.axis;
    }

    public NodeSet preSelect(Sequence contextSequence, boolean useContext) throws XPathException {
        this.preselectResult = null;
        Expression termsExpr = this.getArgument(1);
        Expression flagsExpr = this.getArgumentCount() == 3 ? this.getArgument(2) : null;
        boolean matchAll = this.getMatchFlag(flagsExpr, contextSequence);
        List terms = this.getSearchTerms(termsExpr, contextSequence);
        NodeSet[] hits = this.getMatches(contextSequence.getDocumentSet(), useContext ? contextSequence.toNodeSet() : null, 1, this.contextQName, terms, matchAll);
        this.preselectResult = hits[0];
        if (this.preselectResult != null) {
            for (int k = 1; k < hits.length; ++k) {
                if (hits[k] == null) continue;
                this.preselectResult = this.type == 1 ? this.preselectResult.deepIntersection(hits[k]) : this.preselectResult.union(hits[k]);
            }
        } else {
            this.preselectResult = NodeSet.EMPTY_SET;
        }
        return this.preselectResult;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        NodeSet result;
        if (this.preselectResult != null && this.preselectResult.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (this.preselectResult == null && !this.checkForQNameIndex(contextSequence)) {
            this.contextQName = null;
        }
        Expression path = this.getArgument(0);
        Expression termsExpr = this.getArgument(1);
        Expression flagsExpr = this.getArgumentCount() == 3 ? this.getArgument(2) : null;
        boolean matchAll = this.getMatchFlag(flagsExpr, contextSequence);
        if (path == null || !Dependency.dependsOn(path, 2)) {
            boolean canCache;
            boolean bl = canCache = (this.getTermDependencies() & 2) == 0;
            if (canCache && this.cached != null && this.cached.isValid(contextSequence, contextItem)) {
                return this.cached.getResult();
            }
            if (this.contextStep == null || this.preselectResult == null) {
                NodeSet nodes = path == null ? contextSequence.toNodeSet() : path.eval(contextSequence).toNodeSet();
                List terms = this.getSearchTerms(termsExpr, contextSequence);
                result = this.evalQuery(nodes, terms, matchAll).toNodeSet();
            } else {
                this.contextStep.setPreloadNodeSets(true);
                this.contextStep.setPreloadedData(contextSequence.getDocumentSet(), this.preselectResult);
                result = path.eval(contextSequence).toNodeSet();
            }
            if (canCache && contextSequence instanceof NodeSet) {
                this.cached = new CachedResult((NodeSet)contextSequence, contextItem, result);
            }
        } else {
            result = new ExtArrayNodeSet();
            SequenceIterator i = contextSequence.iterate();
            while (i.hasNext()) {
                Item current = i.nextItem();
                List terms = this.getSearchTerms(termsExpr, contextSequence);
                NodeSet nodes = path == null ? contextSequence.toNodeSet() : path.eval(current.toSequence()).toNodeSet();
                Sequence temp = this.evalQuery(nodes, terms, matchAll);
                result.addAll(temp);
            }
        }
        this.preselectResult = null;
        return result;
    }

    private boolean checkForQNameIndex(Sequence contextSequence) {
        if (contextSequence == null || this.contextQName == null) {
            return false;
        }
        boolean hasQNameIndex = true;
        Iterator i = contextSequence.getCollectionIterator();
        while (i.hasNext()) {
            Collection collection = (Collection)i.next();
            if (collection.getURI().equals(XmldbURI.SYSTEM_COLLECTION_URI)) continue;
            FulltextIndexSpec config = collection.getFulltextIndexConfiguration(this.context.getBroker());
            if (config != null) {
                hasQNameIndex = config.hasQNameIndex(this.contextQName);
            }
            if (hasQNameIndex) continue;
            if (!LOG.isTraceEnabled()) break;
            LOG.trace((Object)("cannot use index on QName: " + this.contextQName + ". Collection " + collection.getURI() + " does not define an index"));
            break;
        }
        return hasQNameIndex;
    }

    protected List getSearchTerms(Expression termsExpr, Sequence contextSequence) throws XPathException {
        ArrayList<String> terms = new ArrayList<String>();
        Sequence seq = termsExpr.eval(contextSequence);
        if (seq.hasOne()) {
            terms.add(this.translateRegexp(seq.itemAt(0).getStringValue()));
        } else {
            SequenceIterator it = seq.iterate();
            while (it.hasNext()) {
                terms.add(this.translateRegexp(it.nextItem().getStringValue()));
            }
        }
        return terms;
    }

    private boolean getMatchFlag(Expression flagsExpr, Sequence contextSequence) throws XPathException {
        boolean matchAll = false;
        if (flagsExpr != null) {
            String flagStr = flagsExpr.eval(contextSequence).getStringValue();
            matchAll = flagStr.equals(MATCH_ALL_FLAG);
        }
        return matchAll;
    }

    public int getDependencies() {
        int deps = 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            deps |= this.getArgument(i).getDependencies();
        }
        return deps;
    }

    public Sequence evalQuery(NodeSet nodes, List terms, boolean matchAll) throws XPathException {
        if (terms == null || terms.size() == 0) {
            return Sequence.EMPTY_SEQUENCE;
        }
        NodeSet[] hits = this.getMatches(nodes.getDocumentSet(), nodes, 0, this.contextQName, terms, matchAll);
        NodeSet result = hits[0];
        if (result != null) {
            for (int k = 1; k < hits.length; ++k) {
                if (hits[k] == null) continue;
                result = this.type == 1 ? result.deepIntersection(hits[k]) : result.union(hits[k]);
            }
            return result;
        }
        return NodeSet.EMPTY_SET;
    }

    protected NodeSet[] getMatches(DocumentSet docs, NodeSet contextSet, int axis, QName qname, List terms, boolean matchAll) throws XPathException {
        NodeSet[] hits = new NodeSet[terms.size()];
        for (int k = 0; k < terms.size(); ++k) {
            hits[k] = this.context.getBroker().getTextEngine().getNodesContaining(this.context, docs, contextSet, axis, qname, (String)terms.get(k), 1, matchAll);
            LOG.debug((Object)("Matches for " + terms.get(k) + ": " + hits[k].getLength()));
        }
        return hits;
    }

    protected int getTermDependencies() throws XPathException {
        int deps = 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            deps |= this.getArgument(i).getDependencies();
        }
        return deps;
    }

    public void resetState() {
        super.resetState();
        this.cached = null;
    }

    protected String translateRegexp(String pattern) throws XPathException {
        try {
            pattern = RegexTranslator.translate(pattern, true);
        }
        catch (RegexTranslator.RegexSyntaxException e) {
            throw new XPathException(this.getASTNode(), "Conversion from XPath2 to Java regular expression syntax failed: " + e.getMessage(), e);
        }
        return pattern;
    }
}

