/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.net.URISyntaxException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class DocumentNameOrId
extends BasicFunction {
    public static final FunctionSignature docNameSignature = new FunctionSignature(new QName("document-name", "http://exist-db.org/xquery/util", "util"), "Returns the name of a document (excluding the collection path). The argument can either be a node or a string path pointing to a resource in the database. If the resource does not exist or the node does not belong to a stored document, the empty sequence is returned.", new SequenceType[]{new SequenceType(11, 2)}, new SequenceType(22, 3));
    public static final FunctionSignature docIdSignature = new FunctionSignature(new QName("document-id", "http://exist-db.org/xquery/util", "util"), "Returns the internal integer id of a document. The argument can either be a node or a string path pointing to a resource in the database. If the resource does not exist or the node does not belong to a stored document, the empty sequence is returned.", new SequenceType[]{new SequenceType(11, 2)}, new SequenceType(38, 3));

    public DocumentNameOrId(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        DocumentImpl doc = null;
        if (Type.subTypeOf(args[0].getItemType(), -1)) {
            NodeValue node = (NodeValue)args[0].itemAt(0);
            if (node.getImplementationType() == 1) {
                NodeProxy proxy = (NodeProxy)node;
                doc = proxy.getDocument();
            }
        } else {
            String path = args[0].getStringValue();
            try {
                doc = this.context.getBroker().getXMLResource(XmldbURI.xmldbUriFor(path), 0);
            }
            catch (URISyntaxException e) {
                throw new XPathException(this.getASTNode(), "Invalid resource uri: " + path, e);
            }
            catch (PermissionDeniedException e) {
                throw new XPathException(this.getASTNode(), path + ": permission denied to read resource");
            }
            finally {
                if (doc != null) {
                    doc.getUpdateLock().release(0);
                }
            }
        }
        if (doc != null) {
            if ("document-name".equals(this.getSignature().getName().getLocalName())) {
                return new StringValue(doc.getFileURI().toString());
            }
            return new IntegerValue(doc.getDocId(), 38);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

