/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FunctionFunction
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("function", "http://exist-db.org/xquery/util", "util"), "Creates a reference to an XQuery function which can later be called from util:call. This allows for higher-order functions to be implemented in XQuery. A higher-order function is a function that takes another function as argument. The first argument represents the name of the function, which should bea valid QName. The second argument is the arity of the function. If nofunction can be found that matches the name and arity, an error is thrown. Please note: due to the special character of util:function, the arguments to this function have to be literals or need to be resolvable at compile time at least.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(31, 2)}, new SequenceType(101, 2));
    private FunctionCall resolvedFunction = null;

    public FunctionFunction(XQueryContext context) {
        super(context, signature);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        super.analyze(contextInfo);
        String funcName = this.getArgument(0).eval(null).getStringValue();
        int arity = ((NumericValue)this.getArgument(1).eval(null).itemAt(0)).getInt();
        FunctionCall funcCall = this.lookupFunction(funcName, arity);
        contextInfo.addFlag(1);
        funcCall.analyze(contextInfo);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String funcName = args[0].getStringValue();
        int arity = ((NumericValue)args[1].itemAt(0)).getInt();
        this.resolvedFunction = this.lookupFunction(funcName, arity);
        return new FunctionReference(this.resolvedFunction);
    }

    private FunctionCall lookupFunction(String funcName, int arity) throws XPathException {
        UserDefinedFunction func;
        QName qname;
        try {
            qname = QName.parse(this.context, funcName, this.context.getDefaultFunctionNamespace());
        }
        catch (XPathException e) {
            e.setASTNode(this.getASTNode());
            throw e;
        }
        Module module = this.context.getModule(qname.getNamespaceURI());
        if (module == null) {
            func = this.context.resolveFunction(qname, arity);
            if (func == null) {
                throw new XPathException(this.getASTNode(), Messages.getMessage("S03", qname, Integer.toString(arity)));
            }
        } else {
            if (module.isInternalModule()) {
                throw new XPathException(this.getASTNode(), "Cannot create a reference to an internal Java function");
            }
            func = ((ExternalModule)module).getFunction(qname, arity);
        }
        FunctionCall funcCall = new FunctionCall(this.context, func);
        funcCall.setASTNode(this.getASTNode());
        return funcCall;
    }

    public void resetState() {
        super.resetState();
        if (this.resolvedFunction != null) {
            this.resolvedFunction.resetState();
        }
        this.resolvedFunction = null;
    }
}

