/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import org.exist.dom.QName;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class LogFunction
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("log", "http://exist-db.org/xquery/util", "util"), "Logs the message specified in $b to the current logger. $a indicates the log priority, e.g. 'debug' or 'warn'.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(11, 7)}, new SequenceType(11, 1)), new FunctionSignature(new QName("log-system-out", "http://exist-db.org/xquery/util", "util"), "Logs the message specified in $b to System.out.", new SequenceType[]{new SequenceType(11, 7)}, new SequenceType(11, 1)), new FunctionSignature(new QName("log-system-err", "http://exist-db.org/xquery/util", "util"), "Logs the message specified in $b to System.err.", new SequenceType[]{new SequenceType(11, 7)}, new SequenceType(11, 1))};

    public LogFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        SequenceIterator i;
        if (this.isCalledAs("log")) {
            i = args[1].unorderedIterator();
            if (args[1].isEmpty()) {
                return Sequence.EMPTY_SEQUENCE;
            }
        } else {
            i = args[0].unorderedIterator();
            if (args[0].isEmpty()) {
                return Sequence.EMPTY_SEQUENCE;
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append("(Line: ");
        buf.append(this.getASTNode().getLine());
        buf.append(") ");
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (Type.subTypeOf(next.getType(), -1)) {
                Serializer serializer = this.context.getBroker().getSerializer();
                serializer.reset();
                try {
                    buf.append(serializer.serialize((NodeValue)next));
                    continue;
                }
                catch (SAXException e) {
                    throw new XPathException(this.getASTNode(), "An exception occurred while serializing node to log: " + e.getMessage(), e);
                }
            }
            buf.append(next.getStringValue());
        }
        if (this.isCalledAs("log")) {
            String priority = args[0].getStringValue();
            if (priority.equalsIgnoreCase("error")) {
                LOG.error((Object)buf);
            } else if (priority.equalsIgnoreCase("warn")) {
                LOG.warn((Object)buf);
            } else if (priority.equalsIgnoreCase("info")) {
                LOG.info((Object)buf);
            } else if (priority.equalsIgnoreCase("trace")) {
                LOG.trace((Object)buf);
            } else {
                LOG.debug((Object)buf);
            }
        } else if (this.isCalledAs("log-system-out")) {
            System.out.println(buf);
        } else if (this.isCalledAs("log-system-err")) {
            System.err.println(buf);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

