/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.User;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.XMLDBException;

public class XMLDBIsAdmin
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("is-admin-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns true if user is an Admin. Requires username.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(23, 3));

    public XMLDBIsAdmin(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        BooleanValue booleanValue;
        String userName = args[0].getStringValue();
        LocalCollection collection = null;
        try {
            collection = new LocalCollection(this.context.getUser(), this.context.getBroker().getBrokerPool(), XmldbURI.ROOT_COLLECTION_URI, this.context.getAccessContext());
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            User user = ums.getUser(userName);
            if (user == null) {
                Sequence sequence = Sequence.EMPTY_SEQUENCE;
                return sequence;
            }
            booleanValue = user.hasDbaRole() ? BooleanValue.TRUE : BooleanValue.FALSE;
        }
        catch (XMLDBException xe) {
            throw new XPathException(this.getASTNode(), "Failed to access user " + userName, xe);
        }
        finally {
            if (null != collection) {
                try {
                    collection.close();
                }
                catch (XMLDBException e) {}
            }
        }
        return booleanValue;
    }
}

