/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.Permission;
import org.exist.security.PermissionFactory;
import org.exist.security.User;
import org.exist.xmldb.UserManagementService;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.functions.xmldb.XMLDBAbstractCollectionManipulator;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class XMLDBSetResourcePermissions
extends XMLDBAbstractCollectionManipulator {
    public static final FunctionSignature signature = new FunctionSignature(new QName("set-resource-permissions", "http://exist-db.org/xquery/xmldb", "xmldb"), "Sets the permissions of the specified resource. $a is the collection, which can be specified as a simple collection path or an XMLDB URI. $b denotes the resource tochange. $c specifies the user which will become the owner of the resource, $d the group. The final argument contains the permissions, specified as an xs:integer value. PLEASE REMEMBER that 0755 is 7*64+5*8+5, NOT decimal 755.", new SequenceType[]{new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(22, 2), new SequenceType(31, 2)}, new SequenceType(11, 1));

    public XMLDBSetResourcePermissions(XQueryContext context) {
        super(context, signature);
    }

    public Sequence evalWithCollection(Collection collection, Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            User u;
            Permission p;
            UserManagementService ums;
            Resource res = collection.getResource(new AnyURIValue(args[1].getStringValue()).toXmldbURI().toString());
            if (res != null) {
                ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
                String user = args[2].getStringValue();
                String group = args[3].getStringValue();
                int mode = ((IntegerValue)args[4].convertTo(31)).getInt();
                if (null == user || 0 == user.length()) {
                    throw new XPathException(this.getASTNode(), "Needs a valid user name, not: " + user);
                }
                if (null == group || 0 == group.length()) {
                    throw new XPathException(this.getASTNode(), "Needs a valid group name, not: " + group);
                }
                p = PermissionFactory.getPermission(user, group, mode);
                u = ums.getUser(user);
                if (null == u) {
                    throw new XPathException(this.getASTNode(), "Needs a valid user name, not: " + user);
                }
            } else {
                throw new XPathException(this.getASTNode(), "Unable to locate resource " + args[1].getStringValue());
            }
            p.setOwner(u);
            ums.setPermissions(res, p);
        }
        catch (XMLDBException xe) {
            throw new XPathException(this.getASTNode(), "Unable to change resource permissions", xe);
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

