/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.net.URISyntaxException;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class XMLDBURIFunctions
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("encode", "http://exist-db.org/xquery/xmldb", "xmldb"), "Encodes the string provided in $a such that it will be a valid collection or resource path.  Provides similar functionality to java's URLEncoder.encode() function, with some enhancements", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 2)), new FunctionSignature(new QName("encode-uri", "http://exist-db.org/xquery/xmldb", "xmldb"), "Encodes the string provided in $a such that it will be a valid collection or resource path.  Provides similar functionality to java's URLEncoder.encode() function, with some enhancements.  Returns an xs:anyURI object representing a valid XmldbURI", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(25, 2)), new FunctionSignature(new QName("decode", "http://exist-db.org/xquery/xmldb", "xmldb"), "Decodes the string provided in $a such that any percent encoded octets will be translated to their decoded UTF-8 representation.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 2)), new FunctionSignature(new QName("decode-uri", "http://exist-db.org/xquery/xmldb", "xmldb"), "Decodes the URI provided in $a such that any percent encoded octets will be translated to their decoded UTF-8 representation.", new SequenceType[]{new SequenceType(25, 2)}, new SequenceType(22, 2))};

    public XMLDBURIFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        try {
            if (this.isCalledAs("encode")) {
                return new StringValue(URIUtils.urlEncodePartsUtf8(args[0].getStringValue()));
            }
            if (this.isCalledAs("encode-uri")) {
                return new AnyURIValue(URIUtils.encodeXmldbUriFor(args[0].getStringValue()));
            }
            return new StringValue(URIUtils.urlDecodeUtf8(args[0].getStringValue()));
        }
        catch (URISyntaxException e) {
            throw new XPathException("URI Syntax Exception: " + e.getMessage(), e);
        }
    }
}

