/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import org.exist.dom.QName;
import org.exist.security.User;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.xmldb.api.base.XMLDBException;

public class XMLDBUserAccess
extends BasicFunction {
    public static final FunctionSignature fnExistsUser = new FunctionSignature(new QName("exists-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns true if user exists. Requires username.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(23, 2));
    public static final FunctionSignature fnUserGroups = new FunctionSignature(new QName("get-user-groups", "http://exist-db.org/xquery/xmldb", "xmldb"), "Receives the sequence of groups the specified user is a member of.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 6));
    public static final FunctionSignature fnUserHome = new FunctionSignature(new QName("get-user-home", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the home collection of the specified user or the empty sequence if no home collection is assigned to the user.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(25, 3));

    public XMLDBUserAccess(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String userName = args[0].getStringValue();
        LocalCollection collection = null;
        try {
            collection = new LocalCollection(this.context.getUser(), this.context.getBroker().getBrokerPool(), XmldbURI.ROOT_COLLECTION_URI, this.context.getAccessContext());
            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
            User user = ums.getUser(userName);
            if (this.isCalledAs("exists-user")) {
                BooleanValue booleanValue = null == user ? BooleanValue.FALSE : BooleanValue.TRUE;
                return booleanValue;
            }
            if (user == null) {
                throw new XPathException(this.getASTNode(), "User not found: " + userName);
            }
            if (this.isCalledAs("get-user-groups")) {
                ValueSequence groups = new ValueSequence();
                String[] gl = user.getGroups();
                int i2 = 0;
                while (true) {
                    if (i2 >= gl.length) {
                        ValueSequence i2 = groups;
                        return i2;
                    }
                    groups.add(new StringValue(gl[i2]));
                    ++i2;
                }
            }
            XmldbURI home = user.getHome();
            Sequence sequence = null == home ? Sequence.EMPTY_SEQUENCE : new AnyURIValue(home);
            return sequence;
        }
        catch (XMLDBException xe) {
            throw new XPathException(this.getASTNode(), "Failed to query user " + userName, xe);
        }
        finally {
            if (null != collection) {
                try {
                    collection.close();
                }
                catch (XMLDBException e) {}
            }
        }
    }
}

