/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.update;

import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XPathUtil;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.update.Modification;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.util.Messages;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class Delete
extends Modification {
    public Delete(XQueryContext context, Expression select) {
        super(context, select, null);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence inSeq;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (contextItem != null) {
            contextSequence = contextItem.toSequence();
        }
        if (!Type.subTypeOf((inSeq = this.select.eval(contextSequence)).getItemType(), -1)) {
            ValueSequence prevUpdateErrors = null;
            XPathException xpe = new XPathException(this.getASTNode(), Messages.getMessage("D08"));
            Object ctxVarObj = this.context.getXQueryContextVar("_eXist_xquery_update_error");
            prevUpdateErrors = ctxVarObj == null ? new ValueSequence() : (ValueSequence)XPathUtil.javaObjectToXPath(ctxVarObj, this.context);
            prevUpdateErrors.add(new StringValue(xpe.getMessage()));
            this.context.setXQueryContextVar("_eXist_xquery_update_error", prevUpdateErrors);
            if (!inSeq.isEmpty()) {
                throw xpe;
            }
        }
        if (!inSeq.isEmpty()) {
            Txn transaction = this.getTransaction();
            try {
                NotificationService notifier = this.context.getBroker().getBrokerPool().getNotificationService();
                StoredNode[] ql = this.selectAndLock(transaction, inSeq.toNodeSet());
                Modification.IndexListener listener = new Modification.IndexListener(ql);
                for (int i = 0; i < ql.length; ++i) {
                    StoredNode node = ql[i];
                    DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
                    if (!doc.getPermissions().validate(this.context.getUser(), 1)) {
                        throw new XPathException(this.getASTNode(), "permission to update document denied");
                    }
                    doc.getMetadata().setIndexListener(listener);
                    StoredNode parent = (StoredNode)node.getParentNode();
                    if (parent == null) {
                        LOG.debug((Object)"Cannot remove the document element (no parent node)");
                        throw new XPathException(this.getASTNode(), "It is not possible to remove the document element.");
                    }
                    if (parent.getNodeType() != 1) {
                        LOG.debug((Object)("parent = " + parent.getNodeType() + "; " + parent.getNodeName()));
                        throw new XPathException(this.getASTNode(), "you cannot remove the document element. Use update instead");
                    }
                    parent.removeChild(transaction, node);
                    doc.getMetadata().clearIndexListener();
                    doc.getMetadata().setLastModified(System.currentTimeMillis());
                    this.modifiedDocuments.add(doc);
                    this.context.getBroker().storeXMLResource(transaction, doc);
                    notifier.notifyUpdate(doc, 1);
                }
                this.checkFragmentation(transaction, this.modifiedDocuments);
                this.finishTriggers(transaction);
                this.commitTransaction(transaction);
            }
            catch (EXistException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
            catch (PermissionDeniedException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
            catch (LockException e) {
                throw new XPathException(this.getASTNode(), e.getMessage(), e);
            }
            finally {
                this.unlockDocuments();
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", Sequence.EMPTY_SEQUENCE);
        }
        return Sequence.EMPTY_SEQUENCE;
    }

    public void dump(ExpressionDumper dumper) {
    }

    public String toString() {
        return "'Delete' string representation";
    }
}

