/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.GDayValue;
import org.exist.xquery.value.GMonthDayValue;
import org.exist.xquery.value.GMonthValue;
import org.exist.xquery.value.GYearMonthValue;
import org.exist.xquery.value.GYearValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;
import org.exist.xquery.value.YearMonthDurationValue;

public class DateValue
extends AbstractDateTimeValue {
    public DateValue() throws XPathException {
        super(DateValue.stripCalendar(TimeUtils.getInstance().newXMLGregorianCalendar(new GregorianCalendar())));
    }

    public DateValue(String dateString) throws XPathException {
        super(dateString);
        try {
            if (this.calendar.getXMLSchemaType() != DatatypeConstants.DATE) {
                throw new IllegalStateException();
            }
        }
        catch (IllegalStateException e) {
            throw new XPathException("xs:date must not have hour, minute or second fields set");
        }
    }

    public DateValue(XMLGregorianCalendar calendar) throws XPathException {
        super(DateValue.stripCalendar(DateValue.cloneXMLGregorianCalendar(calendar)));
    }

    private static XMLGregorianCalendar stripCalendar(XMLGregorianCalendar calendar) {
        calendar.setHour(Integer.MIN_VALUE);
        calendar.setMinute(Integer.MIN_VALUE);
        calendar.setSecond(Integer.MIN_VALUE);
        calendar.setMillisecond(Integer.MIN_VALUE);
        return calendar;
    }

    protected AbstractDateTimeValue createSameKind(XMLGregorianCalendar cal) throws XPathException {
        return new DateValue(cal);
    }

    protected QName getXMLSchemaType() {
        return DatatypeConstants.DATE;
    }

    public int getType() {
        return 51;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 51: {
                return new DateValue(this.getStringValue());
            }
            case 50: {
                return new DateTimeValue(this.calendar);
            }
            case 56: {
                return new GYearValue(this.calendar);
            }
            case 59: {
                return new GYearMonthValue(this.calendar);
            }
            case 71: {
                return new GMonthDayValue(this.calendar);
            }
            case 58: {
                return new GDayValue(this.calendar);
            }
            case 57: {
                return new GMonthValue(this.calendar);
            }
            case 21: {
                DateValue dv = new DateValue(this.getStringValue());
                return new UntypedAtomicValue(dv.getStringValue());
            }
            case 22: {
                DateValue dv = new DateValue(this.calendar);
                return new StringValue(dv.getStringValue());
            }
        }
        throw new XPathException("err:FORG0001: can not convert " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "') to " + Type.getTypeName(requiredType));
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 51: {
                return new DayTimeDurationValue(this.getTimeInMillis() - ((DateValue)other).getTimeInMillis());
            }
            case 54: {
                return ((YearMonthDurationValue)other).negate().plus(this);
            }
            case 55: {
                return ((DayTimeDurationValue)other).negate().plus(this);
            }
        }
        throw new XPathException("Operand to minus should be of type xdt:yearMonthDuration or xdt:dayTimeDuration; got: " + Type.getTypeName(other.getType()));
    }
}

