/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.math.BigDecimal;
import java.text.Collator;
import org.exist.util.FastStringBuffer;
import org.exist.util.FloatingPointConverter;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class DoubleValue
extends NumericValue {
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    public static final DoubleValue POSITIVE_INFINITY = new DoubleValue(Double.POSITIVE_INFINITY);
    public static final DoubleValue NEGATIVE_INFINITY = new DoubleValue(Double.NEGATIVE_INFINITY);
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    private double value;

    public DoubleValue(double value) {
        this.value = value;
    }

    public DoubleValue(AtomicValue otherValue) throws XPathException {
        try {
            this.value = otherValue.getStringValue().equals("INF") ? Double.POSITIVE_INFINITY : (otherValue.getStringValue().equals("-INF") ? Double.NEGATIVE_INFINITY : (otherValue.getStringValue().equals("NaN") ? Double.NaN : Double.parseDouble(otherValue.getStringValue())));
        }
        catch (NumberFormatException e) {
            throw new XPathException("FORG0001: cannot construct " + Type.getTypeName(this.getItemType()) + " from '" + Type.getTypeName(otherValue.getItemType()) + "(\"" + otherValue.getStringValue() + "\")'");
        }
    }

    public int getType() {
        return 34;
    }

    public String getStringValue() {
        FastStringBuffer sb = new FastStringBuffer(20);
        FloatingPointConverter.appendDouble(sb, this.value).getNormalizedString(0);
        return sb.toString();
    }

    public double getValue() {
        return this.value;
    }

    public boolean hasFractionalPart() {
        if (this.isNaN()) {
            return false;
        }
        if (this.isInfinite()) {
            return false;
        }
        return new DecimalValue(new BigDecimal(this.value)).hasFractionalPart();
    }

    public Item itemAt(int pos) {
        return pos == 0 ? this : null;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public boolean isZero() {
        return Double.compare(Math.abs(this.value), 0.0) == 0;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 30: 
            case 34: {
                return this;
            }
            case 33: {
                return new FloatValue(new Float(this.value).floatValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 32: {
                if (this.isNaN()) {
                    throw new XPathException("FORG0001: can not convert " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "') to " + Type.getTypeName(requiredType));
                }
                if (this.isInfinite()) {
                    throw new XPathException("FORG0001: can not convert " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "') to " + Type.getTypeName(requiredType));
                }
                return new DecimalValue(new BigDecimal(this.value));
            }
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                if (this.isNaN()) {
                    throw new XPathException("FORG0001: can not convert " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "') to " + Type.getTypeName(requiredType));
                }
                if (Double.isInfinite(this.value)) {
                    throw new XPathException("FORG0001: can not convert " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "') to " + Type.getTypeName(requiredType));
                }
                if (this.value > 2.147483647E9) {
                    throw new XPathException("err:FOCA0003: Value is out of range for type xs:integer");
                }
                return new IntegerValue((long)this.value, requiredType);
            }
            case 23: {
                return new BooleanValue(this.effectiveBooleanValue());
            }
        }
        throw new XPathException("FORG0001: cannot cast '" + Type.getTypeName(this.getItemType()) + "(\"" + this.getStringValue() + "\")' to " + Type.getTypeName(requiredType));
    }

    public double getDouble() throws XPathException {
        return this.value;
    }

    public int getInt() throws XPathException {
        return (int)Math.round(this.value);
    }

    public long getLong() throws XPathException {
        return Math.round(this.value);
    }

    public void setValue(double val) {
        this.value = val;
    }

    public NumericValue ceiling() throws XPathException {
        return new DoubleValue(Math.ceil(this.value));
    }

    public NumericValue floor() throws XPathException {
        return new DoubleValue(Math.floor(this.value));
    }

    public NumericValue round() throws XPathException {
        if (Double.isNaN(this.value)) {
            return this;
        }
        if (Double.isInfinite(this.value)) {
            return this;
        }
        if (this.value == 0.0) {
            return this;
        }
        if (this.value > -0.5 && this.value < 0.0) {
            return new DoubleValue(-0.0);
        }
        if (this.value > -9.223372036854776E18 && this.value < 9.223372036854776E18) {
            return new DoubleValue(Math.round(this.value));
        }
        return this;
    }

    public NumericValue round(IntegerValue precision) throws XPathException {
        return (DoubleValue)((DecimalValue)this.convertTo(32)).round(precision).convertTo(34);
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(this.value - ((DoubleValue)other).value);
        }
        return this.minus((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(this.value + ((DoubleValue)other).value);
        }
        return this.plus((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 34: {
                return new DoubleValue(this.value * ((DoubleValue)other).value);
            }
            case 54: 
            case 55: {
                return other.mult(this);
            }
        }
        return this.mult((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 30)) {
            if (this.isZero() && ((NumericValue)other).isZero()) {
                return NaN;
            }
            if (this.compareTo(ZERO) != 1 && ((NumericValue)other).isZero() && ((NumericValue)other).compareTo(ZERO) != -1) {
                return NEGATIVE_INFINITY;
            }
            if (((NumericValue)other).isZero() && ((NumericValue)other).compareTo(ZERO) != 1) {
                return NEGATIVE_INFINITY;
            }
            if (((NumericValue)other).isZero() && ((NumericValue)other).compareTo(ZERO) != -1) {
                return POSITIVE_INFINITY;
            }
            if (this.isInfinite() && ((NumericValue)other).isInfinite()) {
                return NaN;
            }
        }
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(this.value / ((DoubleValue)other).value);
        }
        return this.div((ComputableValue)other.convertTo(this.getType()));
    }

    public IntegerValue idiv(NumericValue other) throws XPathException {
        ComputableValue result = this.div(other);
        return new IntegerValue(((IntegerValue)result.convertTo(31)).getLong());
    }

    public NumericValue mod(NumericValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(this.value % ((DoubleValue)other).value);
        }
        return this.mod((NumericValue)other.convertTo(this.getType()));
    }

    public NumericValue negate() throws XPathException {
        return new DoubleValue(-this.value);
    }

    public NumericValue abs() throws XPathException {
        return new DoubleValue(Math.abs(this.value));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(Math.max(this.value, ((DoubleValue)other).value));
        }
        return new DoubleValue(Math.max(this.value, ((DoubleValue)other.convertTo((int)34)).value));
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(Math.min(this.value, ((DoubleValue)other).value));
        }
        return new DoubleValue(Math.min(this.value, ((DoubleValue)other.convertTo((int)34)).value));
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(DoubleValue.class)) {
            return 0;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 3;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 4;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 5;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 6;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 1;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 2;
        }
        if (javaClass == String.class) {
            return 7;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 8;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(DoubleValue.class)) {
            return this;
        }
        if (target == Double.class || target == Double.TYPE) {
            return new Double(this.value);
        }
        if (target == Float.class || target == Float.TYPE) {
            return new Float(this.value);
        }
        if (target == Long.class || target == Long.TYPE) {
            return new Long(((IntegerValue)this.convertTo(37)).getValue());
        }
        if (target == Integer.class || target == Integer.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return new Integer((int)v.getValue());
        }
        if (target == Short.class || target == Short.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return new Short((short)v.getValue());
        }
        if (target == Byte.class || target == Byte.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return new Byte((byte)v.getValue());
        }
        if (target == String.class) {
            return this.getStringValue();
        }
        if (target == Boolean.class) {
            return this.effectiveBooleanValue();
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public int getSerializedSize() {
        return 9;
    }

    public int compareTo(Object o) {
        AtomicValue other = (AtomicValue)o;
        if (Type.subTypeOf(other.getType(), 34)) {
            return Double.compare(this.value, ((DoubleValue)other).value);
        }
        return this.getType() < other.getType() ? -1 : 1;
    }
}

