/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.math.BigDecimal;
import java.text.Collator;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.YearMonthDurationValue;

abstract class OrderedDurationValue
extends DurationValue {
    OrderedDurationValue(Duration duration) throws XPathException {
        super(duration);
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.isEmpty()) {
            return false;
        }
        int r = this.compareTo(collator, other);
        if (operator != 4 && operator != 5) {
            if (this.getType() == 53) {
                throw new XPathException("XPTY0004: cannot compare unordered " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(other.getType()));
            }
            if (other.getType() == 53) {
                throw new XPathException("XPTY0004: cannot compare " + Type.getTypeName(this.getType()) + " to unordered " + Type.getTypeName(other.getType()));
            }
            if (Type.getCommonSuperType(this.getType(), other.getType()) == 53) {
                throw new XPathException("XPTY0004: cannot compare " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(other.getType()));
            }
        }
        switch (operator) {
            case 4: {
                return r == 0;
            }
            case 5: {
                return r != 0;
            }
            case 0: {
                return r == -1;
            }
            case 3: {
                return r == -1 || r == 0;
            }
            case 1: {
                return r == 1;
            }
            case 2: {
                return r == 1 || r == 0;
            }
        }
        throw new XPathException("Unknown operator type in comparison");
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.isEmpty()) {
            return -1;
        }
        if (Type.subTypeOf(other.getType(), 53)) {
            int r = this.duration.compare(((DurationValue)other).duration);
            if (r == 0 && (BigDecimal)this.duration.getField(DatatypeConstants.SECONDS) != null && (BigDecimal)((DurationValue)other).duration.getField(DatatypeConstants.SECONDS) != null) {
                if (((BigDecimal)this.duration.getField(DatatypeConstants.SECONDS)).compareTo((BigDecimal)((DurationValue)other).duration.getField(DatatypeConstants.SECONDS)) == 0) {
                    return 0;
                }
                return ((BigDecimal)this.duration.getField(DatatypeConstants.SECONDS)).compareTo((BigDecimal)((DurationValue)other).duration.getField(DatatypeConstants.SECONDS)) == -1 ? -1 : 1;
            }
            if (r == 2) {
                throw new RuntimeException("indeterminate order between totally ordered duration values " + this + " and " + other);
            }
            return r;
        }
        throw new XPathException("Type error: cannot compare " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() != this.getType()) {
            throw new XPathException("cannot obtain maximum across different non-numeric data types");
        }
        return this.compareTo(null, other) > 0 ? this : other;
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() != this.getType()) {
            throw new XPathException("cannot obtain minimum across different non-numeric data types");
        }
        return this.compareTo(null, other) < 0 ? this : other;
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 55: {
                Duration a = this.getCanonicalDuration();
                Duration b = ((OrderedDurationValue)other).getCanonicalDuration();
                Duration result = this.createSameKind(a.add(b)).getCanonicalDuration();
                return new DayTimeDurationValue(result);
            }
            case 54: {
                Duration a = this.getCanonicalDuration();
                Duration b = ((OrderedDurationValue)other).getCanonicalDuration();
                Duration result = this.createSameKind(a.add(b)).getCanonicalDuration();
                return new YearMonthDurationValue(result);
            }
            case 53: {
                Duration a = this.getCanonicalDuration();
                Duration b = ((DurationValue)other).getCanonicalDuration();
                Duration result = this.createSameKind(a.add(b)).getCanonicalDuration();
                return new DurationValue(result);
            }
            case 50: 
            case 51: 
            case 52: {
                AbstractDateTimeValue date = (AbstractDateTimeValue)other;
                XMLGregorianCalendar gc = (XMLGregorianCalendar)date.calendar.clone();
                gc.add(this.duration);
                if (gc.getYear() < 0) {
                    gc.setYear(gc.getYear() - 1);
                }
                return date.createSameKind(gc);
            }
        }
        throw new XPathException("XPTY0004: cannot add " + Type.getTypeName(other.getType()) + "('" + other.getStringValue() + "') from " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "')");
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 55: {
                if (this.getType() != other.getType()) {
                    throw new IllegalArgumentException("Tried to substract " + Type.getTypeName(other.getType()) + "('" + other.getStringValue() + "') from " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "')");
                }
                Duration a = this.getCanonicalDuration();
                Duration b = ((OrderedDurationValue)other).getCanonicalDuration();
                Duration result = this.createSameKind(a.subtract(b)).getCanonicalDuration();
                return new DayTimeDurationValue(result);
            }
            case 54: {
                if (this.getType() != other.getType()) {
                    throw new IllegalArgumentException("Tried to substract " + Type.getTypeName(other.getType()) + "('" + other.getStringValue() + "') from " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "')");
                }
                Duration a = this.getCanonicalDuration();
                Duration b = ((OrderedDurationValue)other).getCanonicalDuration();
                Duration result = this.createSameKind(a.subtract(b)).getCanonicalDuration();
                return new YearMonthDurationValue(result);
            }
        }
        throw new XPathException("XPTY0004: cannot substract " + Type.getTypeName(other.getType()) + "('" + other.getStringValue() + "') from " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "')");
    }

    protected BigDecimal numberToBigDecimal(ComputableValue x, String exceptionMessagePrefix) throws XPathException {
        if (!Type.subTypeOf(x.getType(), 30)) {
            throw new XPathException(exceptionMessagePrefix + Type.getTypeName(x.getType()));
        }
        if (((NumericValue)x).isInfinite() || ((NumericValue)x).isNaN()) {
            throw new XPathException("Tried to convert '" + (NumericValue)x + "' to BigDecimal");
        }
        if (x.conversionPreference(BigDecimal.class) < Integer.MAX_VALUE) {
            return (BigDecimal)x.toJavaObject(BigDecimal.class);
        }
        return new BigDecimal(((NumericValue)x).getDouble());
    }
}

