/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.CollectionConfiguration;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeIndexListener;
import org.exist.dom.NodeSet;
import org.exist.dom.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.security.xacml.AccessContext;
import org.exist.security.xacml.NullAccessContextException;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.StorageAddress;
import org.exist.storage.XQueryPool;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.w3c.dom.NodeList;

public abstract class Modification {
    protected static final Logger LOG = Logger.getLogger((Class)Modification.class);
    protected String selectStmt = null;
    protected NodeList content = null;
    protected DBBroker broker;
    protected DocumentSet docs;
    protected Map namespaces;
    protected Map variables;
    protected DocumentSet lockedDocuments = null;
    protected DocumentSet modifiedDocuments = new DocumentSet();
    protected Int2ObjectHashMap triggers;
    private AccessContext accessCtx;

    private Modification() {
    }

    public Modification(DBBroker broker, DocumentSet docs, String selectStmt, Map namespaces, Map variables) {
        this.selectStmt = selectStmt;
        this.broker = broker;
        this.docs = docs;
        this.namespaces = new HashMap(namespaces);
        this.variables = new TreeMap(variables);
        this.triggers = new Int2ObjectHashMap(97);
    }

    public final void setAccessContext(AccessContext accessCtx) {
        if (accessCtx == null) {
            throw new NullAccessContextException();
        }
        if (this.accessCtx != null) {
            throw new IllegalStateException("Access context can only be set once.");
        }
        this.accessCtx = accessCtx;
    }

    public final AccessContext getAccessContext() {
        if (this.accessCtx == null) {
            throw new IllegalStateException("Access context has not been set.");
        }
        return this.accessCtx;
    }

    public abstract long process(Txn var1) throws PermissionDeniedException, LockException, EXistException, XPathException;

    public abstract String getName();

    public void setContent(NodeList nodes) {
        this.content = nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeList select(DocumentSet docs) throws PermissionDeniedException, EXistException, XPathException {
        StringSource source;
        XQuery xquery = this.broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(this.broker, source = new StringSource(this.selectStmt));
        XQueryContext context = compiled == null ? xquery.newContext(this.getAccessContext()) : compiled.getContext();
        context.setStaticallyKnownDocuments(docs);
        this.declareNamespaces(context);
        this.declareVariables(context);
        if (compiled == null) {
            try {
                compiled = xquery.compile(context, source);
            }
            catch (IOException e) {
                throw new EXistException("An exception occurred while compiling the query: " + e.getMessage());
            }
        }
        Sequence resultSeq = null;
        try {
            resultSeq = xquery.execute(compiled, null);
        }
        finally {
            pool.returnCompiledXQuery(source, compiled);
        }
        if (!resultSeq.isEmpty() && !Type.subTypeOf(resultSeq.getItemType(), -1)) {
            throw new EXistException("select expression should evaluate to a node-set; got " + Type.getTypeName(resultSeq.getItemType()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("found " + resultSeq.getItemCount() + " for select: " + this.selectStmt));
        }
        return resultSeq.toNodeSet();
    }

    protected void declareVariables(XQueryContext context) throws XPathException {
        Iterator i = this.variables.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            context.declareVariable(entry.getKey().toString(), entry.getValue());
        }
    }

    protected void declareNamespaces(XQueryContext context) throws XPathException {
        Iterator i = this.namespaces.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            context.declareNamespace((String)entry.getKey(), (String)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final StoredNode[] selectAndLock(Txn transaction) throws LockException, PermissionDeniedException, EXistException, XPathException {
        Lock globalLock = this.broker.getBrokerPool().getGlobalUpdateLock();
        try {
            globalLock.acquire(0);
            NodeList nl = this.select(this.docs);
            this.lockedDocuments = ((NodeSet)nl).getDocumentSet();
            this.lockedDocuments.lock(true, false);
            StoredNode[] ql = new StoredNode[nl.getLength()];
            for (int i = 0; i < ql.length; ++i) {
                ql[i] = (StoredNode)nl.item(i);
                DocumentImpl doc = (DocumentImpl)ql[i].getOwnerDocument();
                doc.setBroker(this.broker);
                this.prepareTrigger(transaction, doc);
            }
            StoredNode[] storedNodeArray = ql;
            return storedNodeArray;
        }
        finally {
            globalLock.release(0);
        }
    }

    protected final void unlockDocuments(Txn transaction) {
        if (this.lockedDocuments == null) {
            return;
        }
        Iterator iterator = this.modifiedDocuments.iterator();
        while (iterator.hasNext()) {
            DocumentImpl doc = (DocumentImpl)iterator.next();
            this.finishTrigger(transaction, doc);
        }
        this.triggers.clear();
        this.modifiedDocuments.clear();
        this.lockedDocuments.unlock(true);
        this.lockedDocuments = null;
    }

    protected void checkFragmentation(Txn transaction, DocumentSet docs) throws EXistException {
        int fragmentationLimit = -1;
        if (this.broker.customProperties.get("xupdate.fragmentation") != null) {
            fragmentationLimit = (Integer)this.broker.customProperties.get("xupdate.fragmentation");
        }
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            DocumentImpl next = (DocumentImpl)i.next();
            if (next.getMetadata().getSplitCount() > fragmentationLimit) {
                this.broker.defragXMLResource(transaction, next);
            }
            this.broker.checkXMLResourceConsistency(next);
        }
    }

    private void prepareTrigger(Txn transaction, DocumentImpl doc) {
        CollectionConfiguration config = doc.getCollection().getConfiguration(doc.getBroker());
        DocumentTrigger trigger = null;
        if (config != null) {
            try {
                trigger = (DocumentTrigger)config.newTrigger(1, doc.getBroker(), doc.getCollection());
            }
            catch (CollectionConfigurationException e) {
                LOG.debug((Object)("An error occurred while initializing a trigger for collection " + doc.getCollection().getURI() + ": " + e.getMessage()), (Throwable)e);
            }
            if (trigger != null) {
                try {
                    trigger.prepare(1, doc.getBroker(), transaction, doc.getURI(), doc);
                }
                catch (TriggerException te) {
                    LOG.debug((Object)("Unable to prepare trigger for event UPDATE_DOCUMENT_EVENT: " + te.getMessage()));
                }
                catch (Exception e) {
                    LOG.debug((Object)("Trigger event UPDATE_DOCUMENT_EVENT for collection: " + doc.getCollection().getURI() + " with: " + doc.getURI() + " " + e.getMessage()));
                }
                this.triggers.put(doc.getDocId(), trigger);
            }
        }
    }

    private void finishTrigger(Txn transaction, DocumentImpl doc) {
        DocumentTrigger trigger = (DocumentTrigger)this.triggers.get(doc.getDocId());
        if (trigger != null) {
            try {
                trigger.finish(1, doc.getBroker(), transaction, doc.getURI(), doc);
            }
            catch (Exception e) {
                LOG.debug((Object)("Trigger event UPDATE_DOCUMENT_EVENT for collection: " + doc.getCollection().getURI() + " with: " + doc.getURI() + " " + e.getMessage()));
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<xu:");
        buf.append(this.getName());
        buf.append(" select=\"");
        buf.append(this.selectStmt);
        buf.append("\">");
        buf.append("</xu:");
        buf.append(this.getName());
        buf.append(">");
        return buf.toString();
    }

    static final class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            StoredNode n1 = (StoredNode)o1;
            StoredNode n2 = (StoredNode)o2;
            if (n1.getInternalAddress() == n2.getInternalAddress()) {
                return 0;
            }
            if (n1.getInternalAddress() < n2.getInternalAddress()) {
                return -1;
            }
            return 1;
        }
    }

    static final class IndexListener
    implements NodeIndexListener {
        StoredNode[] nodes;

        public IndexListener(StoredNode[] nodes) {
            this.nodes = nodes;
        }

        public void nodeChanged(StoredNode node) {
            long address = node.getInternalAddress();
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!StorageAddress.equals(this.nodes[i].getInternalAddress(), address)) continue;
                this.nodes[i] = node;
            }
        }

        public void nodeChanged(long oldAddress, long newAddress) {
        }
    }
}

