/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;

public class Remove
extends Modification {
    public Remove(DBBroker broker, DocumentSet docs, String selectStmt, Map namespaces, Map variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long process(Txn transaction) throws PermissionDeniedException, LockException, EXistException, XPathException {
        try {
            StoredNode[] ql = this.selectAndLock(transaction);
            Modification.IndexListener listener = new Modification.IndexListener(ql);
            NotificationService notifier = this.broker.getBrokerPool().getNotificationService();
            for (int i = 0; i < ql.length; ++i) {
                StoredNode node = ql[i];
                DocumentImpl doc = (DocumentImpl)node.getOwnerDocument();
                if (!doc.getPermissions().validate(this.broker.getUser(), 1)) {
                    throw new PermissionDeniedException("permission to update document denied");
                }
                doc.getMetadata().setIndexListener(listener);
                NodeImpl parent = (NodeImpl)node.getParentNode();
                if (parent.getNodeType() != 1) {
                    LOG.debug((Object)("parent = " + parent.getNodeType() + "; " + parent.getNodeName()));
                    throw new EXistException("you cannot remove the document element. Use update instead");
                }
                parent.removeChild(transaction, node);
                doc.getMetadata().clearIndexListener();
                doc.getMetadata().setLastModified(System.currentTimeMillis());
                this.modifiedDocuments.add(doc);
                this.broker.storeXMLResource(transaction, doc);
                notifier.notifyUpdate(doc, 1);
            }
            this.checkFragmentation(transaction, this.modifiedDocuments);
            long l = ql.length;
            return l;
        }
        finally {
            this.unlockDocuments(transaction);
        }
    }

    public String getName() {
        return "remove";
    }
}

