/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.util.Configuration;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.JavaNaming;

public class BuilderConfiguration {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String ELEMENT_VALUE = "element";
    private static final String TYPE_VALUE = "type";
    private Properties _defaultProps = null;
    private Properties _localProps = null;
    private Hashtable _nspackages = new Hashtable();
    private Hashtable _locpackages = new Hashtable();

    public BuilderConfiguration() {
        this.getDefault();
        this._localProps = new Properties(this._defaultProps);
    }

    public synchronized Properties getDefault() {
        if (this._defaultProps == null) {
            this.load();
        }
        return this._defaultProps;
    }

    public String getProperty(String name, String defValue) {
        return this._localProps.getProperty(name, defValue);
    }

    public boolean boundPropertiesEnabled() {
        return TRUE.equalsIgnoreCase(this._localProps.getProperty("org.exolab.castor.builder.boundproperties"));
    }

    public boolean equalsMethod() {
        return TRUE.equalsIgnoreCase(this._localProps.getProperty("org.exolab.castor.builder.equalsmethod"));
    }

    public void setEqualsMethod(boolean equals) {
        String value = equals ? TRUE : FALSE;
        this._localProps.setProperty("org.exolab.castor.builder.equalsmethod", value);
    }

    public boolean classDescFieldNames() {
        return this._localProps.getProperty("org.exolab.castor.builder.classdescfieldnames", "").equalsIgnoreCase(TRUE);
    }

    public boolean generateExtraCollectionMethods() {
        return this._localProps.getProperty("org.exolab.castor.builder.extraCollectionMethods", "").equalsIgnoreCase(TRUE);
    }

    public void setClassDescFieldNames(boolean classDescFieldNames) {
        String value = classDescFieldNames ? TRUE : FALSE;
        this._localProps.getProperty("org.exolab.castor.builder.classdescfieldnames", value);
    }

    public boolean usePrimitiveWrapper() {
        return this._localProps.getProperty("org.exolab.castor.builder.primitivetowrapper", "").equalsIgnoreCase(TRUE);
    }

    public void setPrimitiveWrapper(boolean wrapper) {
        String value = wrapper ? TRUE : FALSE;
        this._localProps.setProperty("org.exolab.castor.builder.primitivetowrapper", value);
    }

    public boolean useEnumeratedTypeInterface() {
        return TRUE.equalsIgnoreCase(this._localProps.getProperty("org.exolab.castor.builder.enumTypeAccessInterface"));
    }

    public void setUseEnumeratedTypeInterface(boolean flag) {
        String value = flag ? TRUE : FALSE;
        this._localProps.setProperty("org.exolab.castor.builder.enumTypeAccessInterface", value);
    }

    public boolean mappingSchemaElement2Java() {
        String value = this._localProps.getProperty("org.exolab.castor.builder.javaclassmapping", "");
        return ELEMENT_VALUE.equalsIgnoreCase(value);
    }

    public boolean mappingSchemaType2Java() {
        String value = this._localProps.getProperty("org.exolab.castor.builder.javaclassmapping", "");
        return TYPE_VALUE.equalsIgnoreCase(value);
    }

    public void setDefaultProperties(Properties properties) {
        Properties defaults = null;
        if (properties == null) {
            defaults = this._defaultProps;
        } else {
            defaults = new Properties(this._defaultProps);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                defaults.setProperty(name, properties.getProperty(name));
            }
        }
        this._localProps = new Properties(defaults);
        this.processNamespacePackageMappings(this._localProps.getProperty("org.exolab.castor.builder.nspackages", ""));
        this.processNamespacePackageMappings(this._localProps.getProperty("org.exolab.castor.xml.nspackages", ""));
    }

    public void setNamespacePackageMapping(String ns, String packageName) {
        this._nspackages.put(ns, packageName);
    }

    public void setLocationPackageMapping(String schemaLocation, String packageName) {
        this._locpackages.put(schemaLocation, packageName);
    }

    protected synchronized void load() {
        if (this._defaultProps == null) {
            this._defaultProps = Configuration.loadProperties("/org/exolab/castor/builder/castorbuilder.properties", "castorbuilder.properties");
            boolean found = false;
            try {
                InputStream is = SourceGenerator.class.getResourceAsStream("/castorbuilder.properties");
                if (is != null) {
                    found = true;
                    this._defaultProps.load(is);
                    is.close();
                }
            }
            catch (Exception except) {
                // empty catch block
            }
            if (!found) {
                try {
                    File file = new File("castorbuilder.properties");
                    if (file.exists() && file.canRead()) {
                        FileInputStream is = new FileInputStream(file);
                        this._defaultProps.load(is);
                        ((InputStream)is).close();
                    }
                }
                catch (Exception except) {
                    // empty catch block
                }
            }
        }
        LocalConfiguration rtconf = LocalConfiguration.getInstance();
        this.processNamespacePackageMappings(rtconf.getProperty("org.exolab.castor.builder.nspackages", ""));
        this.processNamespacePackageMappings(rtconf.getProperty("org.exolab.castor.xml.nspackages", ""));
        this.processNamespacePackageMappings(this._defaultProps.getProperty("org.exolab.castor.builder.nspackages", ""));
        this.processNamespacePackageMappings(this._defaultProps.getProperty("org.exolab.castor.xml.nspackages", ""));
        String prop = this._defaultProps.getProperty("org.exolab.castor.xml.JavaNaming.upperCaseAfterUnderscore", null);
        if (prop != null) {
            JavaNaming.upperCaseAfterUnderscore = Boolean.valueOf(prop);
        }
    }

    public String lookupPackageByNamespace(String nsURL) {
        String javaPackage;
        if (nsURL == null) {
            nsURL = "";
        }
        if ((javaPackage = (String)this._nspackages.get(nsURL)) == null) {
            return "";
        }
        return javaPackage;
    }

    public String lookupPackageByLocation(String schemaLocation) {
        if (schemaLocation == null) {
            return "";
        }
        String javaPackage = (String)this._locpackages.get(schemaLocation);
        if (javaPackage == null) {
            while (schemaLocation.startsWith(".")) {
                if (schemaLocation.startsWith("./")) {
                    schemaLocation = schemaLocation.substring(2);
                    continue;
                }
                if (!schemaLocation.startsWith("../")) continue;
                schemaLocation = schemaLocation.substring(3);
            }
            Enumeration keys = this._locpackages.keys();
            boolean found = false;
            while (keys.hasMoreElements() && !found) {
                String key = (String)keys.nextElement();
                if (!schemaLocation.endsWith(key)) continue;
                javaPackage = (String)this._locpackages.get(key);
                found = true;
            }
            if (javaPackage == null) {
                javaPackage = "";
            }
        }
        return javaPackage;
    }

    protected void processNamespacePackageMappings(String mappings) {
        if (mappings == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(mappings, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int sepIdx = token.indexOf(61);
            if (sepIdx < 0) continue;
            String ns = token.substring(0, sepIdx).trim();
            String javaPackage = token.substring(sepIdx + 1).trim();
            this._nspackages.put(ns, javaPackage);
        }
    }

    public static class Property {
        public static final String BOUND_PROPERTIES = "org.exolab.castor.builder.boundproperties";
        public static final String ENUM_TYPE_ACCESS_INTERFACE = "org.exolab.castor.builder.enumTypeAccessInterface";
        public static final String EXTRA_COLLECTION_METHODS = "org.exolab.castor.builder.extraCollectionMethods";
        public static final String SUPER_CLASS = "org.exolab.castor.builder.superclass";
        public static final String JavaClassMapping = "org.exolab.castor.builder.javaclassmapping";
        public static final String NamespacePackagesOld = "org.exolab.castor.builder.nspackages";
        public static final String NamespacePackages = "org.exolab.castor.xml.nspackages";
        public static final String EqualsMethod = "org.exolab.castor.builder.equalsmethod";
        public static final String Wrapper = "org.exolab.castor.builder.primitivetowrapper";
        public static final String ClassDescFieldNames = "org.exolab.castor.builder.classdescfieldnames";
        public static final String FileName = "castorbuilder.properties";
        static final String ResourceName = "/org/exolab/castor/builder/castorbuilder.properties";
    }
}

