/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.util.Messages;
import org.exolab.castor.util.RegExpEvaluator;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.OutputFormat;
import org.exolab.castor.xml.Serializer;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.XMLSerializerFactory;
import org.exolab.castor.xml.util.DefaultNaming;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class Configuration {
    private static final Log LOG = LogFactory.getLog(Configuration.class);
    static final String TRUE_VALUE = "true";
    static final String ON_VALUE = "on";
    private static Properties _defaultProps;
    private static ConfigValues _defaultValues;

    Configuration() {
    }

    public boolean debug() {
        return Configuration.getDefaultDebug();
    }

    public static boolean getDefaultDebug() {
        Configuration.getDefault();
        return Configuration._defaultValues.debug;
    }

    public boolean strictElements() {
        return Configuration.getDefaultStrictElements();
    }

    public static boolean getDefaultStrictElements() {
        Configuration.getDefault();
        return Configuration._defaultValues.strictElements;
    }

    public boolean marshallingValidation() {
        return Configuration.getDefaultMarshallingValidation();
    }

    public static boolean getDefaultMarshallingValidation() {
        Configuration.getDefault();
        return Configuration._defaultValues.marshallingValidation;
    }

    public Properties getProperties() {
        return Configuration.getDefault();
    }

    public static synchronized Properties getDefault() {
        if (_defaultProps == null) {
            Configuration.loadDefaults();
        }
        return _defaultProps;
    }

    public String getProperty(String name, String defValue) {
        return this.getProperties().getProperty(name, defValue);
    }

    public static String getDefaultProperty(String name, String defValue) {
        return Configuration.getDefault().getProperty(name, defValue);
    }

    public XMLNaming getXMLNaming() {
        return Configuration.getDefaultXMLNaming();
    }

    public static XMLNaming getDefaultXMLNaming() {
        if (Configuration._defaultValues.naming != null) {
            return Configuration._defaultValues.naming;
        }
        String prop = Configuration.getDefaultProperty("org.exolab.castor.xml.naming", null);
        if (prop == null || prop.equalsIgnoreCase("lower")) {
            Configuration._defaultValues.naming = new DefaultNaming();
        } else if (prop.equalsIgnoreCase("mixed")) {
            DefaultNaming dn = new DefaultNaming();
            dn.setStyle((short)1);
            Configuration._defaultValues.naming = dn;
        } else {
            try {
                Class<?> cls = Class.forName(prop);
                Configuration._defaultValues.naming = (XMLNaming)cls.newInstance();
            }
            catch (Exception except) {
                throw new RuntimeException("Failed to load XMLNaming: " + except);
            }
        }
        return Configuration._defaultValues.naming;
    }

    public Parser getParser() {
        return Configuration.getDefaultParser();
    }

    public static Parser getDefaultParser() {
        return Configuration.getDefaultParser(null);
    }

    public static Parser getDefaultParser(String features) {
        Parser parser;
        String prop = Configuration.getDefault().getProperty("org.exolab.castor.parser.validation", "false");
        boolean validation = prop.equalsIgnoreCase(TRUE_VALUE) || prop.equalsIgnoreCase(ON_VALUE);
        prop = Configuration.getDefault().getProperty("org.exolab.castor.parser.namespaces", "false");
        boolean namespaces = prop.equalsIgnoreCase(TRUE_VALUE) || prop.equalsIgnoreCase(ON_VALUE);
        prop = Configuration.getDefault().getProperty("org.exolab.castor.parser");
        if (prop == null || prop.length() == 0) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(namespaces);
            factory.setValidating(validation);
            try {
                SAXParser saxParser = factory.newSAXParser();
                return saxParser.getParser();
            }
            catch (ParserConfigurationException pcx) {
                LOG.error(Messages.format("conf.configurationError", pcx));
            }
            catch (SAXException sx) {
                LOG.error(Messages.format("conf.configurationError", sx));
            }
        }
        if (prop == null || prop.length() == 0 || prop.equalsIgnoreCase("xerces")) {
            prop = "org.apache.xerces.parsers.SAXParser";
        }
        try {
            Class<?> cls = Class.forName(prop);
            parser = (Parser)cls.newInstance();
        }
        catch (Exception except) {
            throw new RuntimeException(Messages.format("conf.failedInstantiateParser", prop, except));
        }
        if (parser instanceof XMLReader) {
            XMLReader xmlReader = (XMLReader)((Object)parser);
            try {
                xmlReader.setFeature("http://xml.org/sax/features/validation", validation);
                xmlReader.setFeature("http://xml.org/sax/features/namespaces", namespaces);
                features = Configuration.getDefault().getProperty("org.exolab.castor.sax.features", features);
                if (features != null) {
                    StringTokenizer token = new StringTokenizer(features, ", ");
                    while (token.hasMoreTokens()) {
                        xmlReader.setFeature(token.nextToken(), true);
                    }
                }
            }
            catch (SAXException except) {
                LOG.error(Messages.format("conf.configurationError", except));
            }
        }
        return parser;
    }

    public NodeType getPrimitiveNodeType() {
        return Configuration.getDefaultPrimitiveNodeType();
    }

    public static NodeType getDefaultPrimitiveNodeType() {
        if (Configuration._defaultValues.primitiveNodeType != null) {
            return Configuration._defaultValues.primitiveNodeType;
        }
        String prop = Configuration.getDefaultProperty("org.exolab.castor.xml.introspector.primitive.nodetype", null);
        if (prop == null) {
            return null;
        }
        Configuration._defaultValues.primitiveNodeType = NodeType.getNodeType(prop);
        return Configuration._defaultValues.primitiveNodeType;
    }

    public XMLReader getXMLReader() {
        return Configuration.getDefaultXMLReader(null);
    }

    public static XMLReader getDefaultXMLReader() {
        return Configuration.getDefaultXMLReader(null);
    }

    public static XMLReader getDefaultXMLReader(String features) {
        XMLReader reader = null;
        String prop = Configuration.getDefault().getProperty("org.exolab.castor.parser.validation", "false");
        boolean validation = prop.equalsIgnoreCase(TRUE_VALUE) || prop.equalsIgnoreCase(ON_VALUE);
        prop = Configuration.getDefault().getProperty("org.exolab.castor.parser.namespaces", "false");
        boolean namespaces = prop.equalsIgnoreCase(TRUE_VALUE) || prop.equalsIgnoreCase(ON_VALUE);
        prop = Configuration.getDefault().getProperty("org.exolab.castor.parser");
        if (prop == null || prop.length() == 0) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(namespaces);
            factory.setValidating(validation);
            try {
                SAXParser saxParser = factory.newSAXParser();
                reader = saxParser.getXMLReader();
            }
            catch (ParserConfigurationException pcx) {
                LOG.error(Messages.format("conf.configurationError", pcx));
            }
            catch (SAXException sx) {
                LOG.error(Messages.format("conf.configurationError", sx));
            }
        }
        if (reader == null) {
            if (prop == null || prop.length() == 0 || prop.equalsIgnoreCase("xerces")) {
                prop = "org.apache.xerces.parsers.SAXParser";
            }
            try {
                Class<?> cls = Class.forName(prop);
                reader = (XMLReader)cls.newInstance();
            }
            catch (Exception except) {
                throw new RuntimeException(Messages.format("conf.failedInstantiateParser", prop, except));
            }
        }
        try {
            reader.setFeature("http://xml.org/sax/features/validation", validation);
            reader.setFeature("http://xml.org/sax/features/namespaces", namespaces);
            features = Configuration.getDefault().getProperty("org.exolab.castor.sax.features", features);
            if (features != null) {
                StringTokenizer token = new StringTokenizer(features, ", ");
                while (token.hasMoreTokens()) {
                    reader.setFeature(token.nextToken(), true);
                }
            }
        }
        catch (SAXException except) {
            LOG.error(Messages.format("conf.configurationError", except));
        }
        return reader;
    }

    public RegExpEvaluator getRegExpEvaluator() {
        return Configuration.getDefaultRegExpEvaluator();
    }

    public static RegExpEvaluator getDefaultRegExpEvaluator() {
        String prop = Configuration.getDefault().getProperty("org.exolab.castor.regexp");
        RegExpEvaluator regex = null;
        if (prop == null) {
            return null;
        }
        try {
            Class<?> cls = Configuration._defaultValues.regExpEvalClass;
            if (cls == null) {
                cls = Class.forName(prop);
            }
            regex = (RegExpEvaluator)cls.newInstance();
        }
        catch (Exception except) {
            throw new RuntimeException(Messages.format("conf.failedInstantiateRegExp", prop, except));
        }
        return regex;
    }

    public abstract Serializer getSerializer();

    public static Serializer getDefaultSerializer() {
        Serializer serializer = Configuration.getSerializerFactory(Configuration.getDefault()).getSerializer();
        serializer.setOutputFormat(Configuration.getDefaultOutputFormat());
        return serializer;
    }

    public abstract OutputFormat getOutputFormat();

    public static OutputFormat getDefaultOutputFormat() {
        boolean indent = false;
        String prop = Configuration.getDefault().getProperty("org.exolab.castor.indent", "");
        indent = prop.equalsIgnoreCase(TRUE_VALUE) || prop.equalsIgnoreCase(ON_VALUE);
        OutputFormat format = Configuration.getSerializerFactory(Configuration.getDefault()).getOutputFormat();
        format.setMethod("xml");
        format.setIndenting(indent);
        if (!indent) {
            format.setPreserveSpace(true);
        }
        return format;
    }

    public abstract DocumentHandler getSerializer(OutputStream var1) throws IOException;

    public static DocumentHandler getDefaultSerializer(OutputStream output) throws IOException {
        Serializer serializer = Configuration.getDefaultSerializer();
        serializer.setOutputByteStream(output);
        DocumentHandler docHandler = serializer.asDocumentHandler();
        if (docHandler == null) {
            throw new RuntimeException(Messages.format("conf.serializerNotSaxCapable", serializer.getClass().getName()));
        }
        return docHandler;
    }

    public abstract DocumentHandler getSerializer(Writer var1) throws IOException;

    public static DocumentHandler getDefaultSerializer(Writer output) throws IOException {
        Serializer serializer = Configuration.getDefaultSerializer();
        serializer.setOutputCharStream(output);
        DocumentHandler docHandler = serializer.asDocumentHandler();
        if (docHandler == null) {
            throw new RuntimeException(Messages.format("conf.serializerNotSaxCapable", serializer.getClass().getName()));
        }
        return docHandler;
    }

    protected static void loadDefaults() {
        _defaultProps = Configuration.loadProperties("/org/exolab/castor/castor.properties", "castor.properties");
        String prop = _defaultProps.getProperty("org.exolab.castor.debug", "");
        if (prop.equalsIgnoreCase(TRUE_VALUE) || prop.equalsIgnoreCase(ON_VALUE)) {
            Configuration._defaultValues.debug = true;
        }
        if ((prop = _defaultProps.getProperty("org.exolab.castor.marshalling.validation", "")).equalsIgnoreCase("false") || prop.equalsIgnoreCase("off")) {
            Configuration._defaultValues.marshallingValidation = false;
        }
        Configuration._defaultValues.strictElements = !(prop = _defaultProps.getProperty("org.exolab.castor.xml.strictelements", "")).equalsIgnoreCase("false") && !prop.equalsIgnoreCase("off");
        prop = null;
    }

    public static Properties loadProperties(String resourceName, String fileName) {
        Properties properties = new Properties();
        boolean found = false;
        try {
            properties.load(Configuration.class.getResourceAsStream(resourceName));
            found = true;
        }
        catch (Exception except) {
            // empty catch block
        }
        String javaHome = null;
        try {
            javaHome = System.getProperty("java.home");
        }
        catch (SecurityException e) {
            LOG.warn(Messages.format("conf.privilegesError", e));
        }
        catch (Exception e) {
            LOG.warn(Messages.format("conf.nonCriticalError", e));
        }
        if (javaHome != null) {
            try {
                File file = new File(javaHome, "lib");
                file = new File(file, fileName);
                if (file.exists()) {
                    properties = new Properties(properties);
                    properties.load(new FileInputStream(file));
                    found = true;
                }
            }
            catch (SecurityException e) {
                LOG.warn(Messages.format("conf.privilegesError", e));
            }
            catch (IOException e) {
                LOG.warn(Messages.format("conf.nonCriticalError", e));
            }
        }
        if (!found) {
            throw new RuntimeException(Messages.format("conf.noDefaultConfigurationFile", fileName));
        }
        return properties;
    }

    protected static XMLSerializerFactory getSerializerFactory(Properties props) {
        XMLSerializerFactory serializerFactory;
        String serializerFactoryName = props.getProperty("org.exolab.castor.xml.serializer.factory", "org.exolab.castor.xml.XercesXMLSerializerFactory");
        try {
            serializerFactory = (XMLSerializerFactory)Class.forName(serializerFactoryName).newInstance();
        }
        catch (Exception except) {
            throw new RuntimeException(Messages.format("conf.failedInstantiateSerializerFactory", serializerFactoryName, except));
        }
        return serializerFactory;
    }

    static {
        _defaultValues = new ConfigValues();
    }

    static class ConfigValues {
        boolean debug = false;
        boolean strictElements = false;
        boolean marshallingValidation = true;
        XMLNaming naming = null;
        NodeType primitiveNodeType = null;
        Class regExpEvalClass = null;

        ConfigValues() {
        }
    }

    static class Features {
        public static final String Validation = "http://xml.org/sax/features/validation";
        public static final String Namespaces = "http://xml.org/sax/features/namespaces";

        Features() {
        }
    }

    public static class Property {
        public static final String PrimitiveNodeType = "org.exolab.castor.xml.introspector.primitive.nodetype";
        public static final String Parser = "org.exolab.castor.parser";
        public static final String ParserValidation = "org.exolab.castor.parser.validation";
        public static final String Namespaces = "org.exolab.castor.parser.namespaces";
        public static final String NamespacePackages = "org.exolab.castor.xml.nspackages";
        public static final String Naming = "org.exolab.castor.xml.naming";
        public static final String MarshallingValidation = "org.exolab.castor.marshalling.validation";
        public static final String Indent = "org.exolab.castor.indent";
        public static final String ParserFeatures = "org.exolab.castor.sax.features";
        public static final String ParserFeatureSeparator = ",";
        public static final String RegExp = "org.exolab.castor.regexp";
        public static final String Debug = "org.exolab.castor.debug";
        public static final String StrictElements = "org.exolab.castor.xml.strictelements";
        public static final String SaveMapKeys = "org.exolab.castor.xml.saveMapKeys";
        public static final String SERIALIZER_FACTORY = "org.exolab.castor.xml.serializer.factory";
        public static final String FileName = "castor.properties";
        static final String ResourceName = "/org/exolab/castor/castor.properties";
        static final String DEFAULT_SERIALIZER_FACTORY = "org.exolab.castor.xml.XercesXMLSerializerFactory";
        public static final String PROPERTY_USE_JDBC30 = "org.castor.jdo.use.jdbc30";
        public static final String PROPERTY_USE_JDBC_PROXIES = "org.exolab.castor.persist.useProxies";
    }
}

