/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.handlers;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.ValidityException;

public class EnumFieldHandler
implements FieldHandler {
    private static final Class[] STRING_ARGS = new Class[]{String.class};
    private Method valueOf = null;
    private FieldHandler handler = null;

    public EnumFieldHandler(Class enumType, FieldHandler handler) {
        this.handler = handler;
        this.init(enumType);
    }

    private void init(Class type) {
        if (type == null) {
            String err = "The Class argument passed to the constructor of EnumMarshalDescriptor cannot be null.";
            throw new IllegalArgumentException(err);
        }
        Method method = null;
        try {
            method = type.getMethod("valueOf", STRING_ARGS);
        }
        catch (NoSuchMethodException nsme) {
            String err = type.getName() + " does not contain the required method: public static " + type.getName() + " valueOf(String);";
            throw new IllegalArgumentException(err);
        }
        int mods = method.getModifiers();
        if (!Modifier.isStatic(mods)) {
            String err = type.getName() + " does not contain the required method: public static " + type.getName() + " valueOf(String);";
            throw new IllegalArgumentException(err);
        }
        this.valueOf = method;
        method = null;
    }

    public Object getValue(Object target) throws IllegalStateException {
        Object val = this.handler.getValue(target);
        String[] result = null;
        if (val == null) {
            return val;
        }
        if (val.getClass().isArray()) {
            int size = Array.getLength(val);
            String[] values = new String[size];
            for (int i = 0; i < size; ++i) {
                Object obj = Array.get(val, i);
                values[i] = obj.toString();
            }
            result = values;
        } else {
            result = val.toString();
        }
        return result;
    }

    public void setValue(Object target, Object value) throws IllegalStateException {
        String[] args = new String[1];
        Object obj = null;
        if (value != null) {
            args[0] = value.toString();
            try {
                obj = this.valueOf.invoke(null, (Object[])args);
            }
            catch (InvocationTargetException ite) {
                Throwable toss = ite.getTargetException();
                throw new IllegalStateException(toss.toString());
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException(iae.toString());
            }
        }
        this.handler.setValue(target, obj);
    }

    public void resetValue(Object targer) {
    }

    public void checkValidity(Object object) throws ValidityException, IllegalStateException {
    }

    public Object newInstance(Object parent) throws IllegalStateException {
        return "";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FieldHandler)) {
            return false;
        }
        return this.handler.getClass().isInstance(obj) || this.getClass().isInstance(obj);
    }
}

