/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.net.URI;
import java.net.URISyntaxException;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Structure;

public class SchemaNames {
    public static final String SCHEMA_PACKAGE = "org.exolab.castor.xml.schema";
    public static final String ALL = "all";
    public static final String ANNOTATION = "annotation";
    public static final String ANY = "any";
    public static final String ANYTYPE = "anyType";
    public static final String ANY_ATTRIBUTE = "anyAttribute";
    public static final String APPINFO = "appinfo";
    public static final String ATTRIBUTE = "attribute";
    public static final String ATTRIBUTE_GROUP = "attributeGroup";
    public static final String CHOICE = "choice";
    public static final String COMPLEX_CONTENT = "complexContent";
    public static final String COMPLEX_TYPE = "complexType";
    public static final String DOCUMENTATION = "documentation";
    public static final String ELEMENT = "element";
    public static final String ENUMERATION = "enumeration";
    public static final String EXTENSION = "extension";
    public static final String FIELD = "field";
    public static final String GROUP = "group";
    public static final String INCLUDE = "include";
    public static final String IMPORT = "import";
    public static final String KEY = "key";
    public static final String KEYREF = "keyref";
    public static final String LIST = "list";
    public static final String MAX_EXCLUSIVE = "maxExclusive";
    public static final String MAX_INCLUSIVE = "maxInclusive";
    public static final String MIN_EXCLUSIVE = "minExclusive";
    public static final String MIN_INCLUSIVE = "minInclusive";
    public static final String REDEFINE = "redefine";
    public static final String RESTRICTION = "restriction";
    public static final String SCHEMA = "schema";
    public static final String SELECTOR = "selector";
    public static final String SEQUENCE = "sequence";
    public static final String SIMPLETYPE_REF = "simpletypeRef";
    public static final String SIMPLE_CONTENT = "simpleContent";
    public static final String SIMPLE_TYPE = "simpleType";
    public static final String UNION = "union";
    public static final String UNIQUE = "unique";
    public static final String ABSTRACT = "abstract";
    public static final String ATTR_FORM_DEFAULT_ATTR = "attributeFormDefault";
    public static final String BASE_ATTR = "base";
    public static final String BLOCK_ATTR = "block";
    public static final String BLOCK_DEFAULT_ATTR = "blockDefault";
    public static final String DEFAULT_ATTR = "default";
    public static final String ELEM_FORM_DEFAULT_ATTR = "elementFormDefault";
    public static final String ID_ATTR = "id";
    public static final String ITEM_TYPE_ATTR = "itemType";
    public static final String FINAL_ATTR = "final";
    public static final String FINAL_DEFAULT_ATTR = "finalDefault";
    public static final String FIXED_ATTR = "fixed";
    public static final String FORM = "form";
    public static final String MAX_OCCURS_ATTR = "maxOccurs";
    public static final String MEMBER_TYPES_ATTR = "memberTypes";
    public static final String MIN_OCCURS_ATTR = "minOccurs";
    public static final String MIXED = "mixed";
    public static final String NAME_ATTR = "name";
    public static final String NAMESPACE = "namespace";
    public static final String NILLABLE_ATTR = "nillable";
    public static final String ORDER_ATTR = "order";
    public static final String PROCESS_CONTENTS = "processContents";
    public static final String REF_ATTR = "ref";
    public static final String REFER_ATTR = "refer";
    public static final String SCHEMALOCATION_ATTR = "schemaLocation";
    public static final String SOURCE_ATTR = "source";
    public static final String SUBSTITUTION_GROUP_ATTR = "substitutionGroup";
    public static final String TARGET_NS_ATTR = "targetNamespace";
    public static final String TYPE_ATTR = "type";
    public static final String USE_ATTR = "use";
    public static final String VALUE_ATTR = "value";
    public static final String VERSION_ATTR = "version";
    public static final String XPATH_ATTR = "xpath";
    public static final String INTEGER_TYPE = "integer";
    public static final String INT_TYPE = "int";
    public static final String STRING_TYPE = "string";
    public static final String NAMESPACE_ANY = "##any";
    public static final String NAMESPACE_LOCAL = "##local";
    public static final String NAMESPACE_OTHER = "##other";
    public static final String NAMESPACE_TARGET = "##targetNamespace";
    public static final String LAX = "lax";
    public static final String SKIP = "skip";
    public static final String STRICT = "strict";
    public static final String WILDCARD = "wildcard";

    public static String getStructureName(Structure structure) {
        if (structure == null) {
            return null;
        }
        switch (structure.getStructureType()) {
            case 0: {
                return ANYTYPE;
            }
            case 1: {
                return ANNOTATION;
            }
            case 2: {
                return APPINFO;
            }
            case 3: {
                return ATTRIBUTE;
            }
            case 4: {
                return ATTRIBUTE_GROUP;
            }
            case 5: {
                return COMPLEX_CONTENT;
            }
            case 6: {
                return COMPLEX_TYPE;
            }
            case 7: {
                return DOCUMENTATION;
            }
            case 8: {
                return ELEMENT;
            }
            case 9: {
                Facet facet = (Facet)structure;
                return facet.getName();
            }
            case 10: {
                Group group = (Group)structure;
                Order order = group.getOrder();
                return order.toString();
            }
            case 11: {
                return FIELD;
            }
            case 12: {
                return SELECTOR;
            }
            case 13: {
                return KEY;
            }
            case 14: {
                return KEYREF;
            }
            case 15: {
                return LIST;
            }
            case 16: {
                return GROUP;
            }
            case 17: {
                return GROUP;
            }
            case 18: {
                return REDEFINE;
            }
            case 19: {
                return SCHEMA;
            }
            case 20: {
                return SIMPLE_CONTENT;
            }
            case 21: {
                return SIMPLE_TYPE;
            }
            case 22: {
                return UNION;
            }
            case 23: {
                return UNIQUE;
            }
            case 24: {
                return ANY;
            }
        }
        return null;
    }

    public static boolean isGroupName(String name) {
        return GROUP.equals(name) || SEQUENCE.equals(name) || CHOICE.equals(name) || ALL.equals(name);
    }

    public static boolean isNamespaceName(String name) {
        boolean result;
        boolean bl = result = NAMESPACE_ANY.equals(name) || NAMESPACE_LOCAL.equals(name) || NAMESPACE_OTHER.equals(name) || NAMESPACE_TARGET.equals(name);
        if (result) {
            return result;
        }
        try {
            URI temp = new URI(name);
            temp = null;
            result = true;
        }
        catch (URISyntaxException e) {
            result = false;
        }
        return result;
    }

    public static boolean isProcessName(String name) {
        return LAX.equals(name) || SKIP.equals(name) || STRICT.equals(name);
    }
}

