/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.FacetList;
import org.exolab.castor.xml.schema.FacetListEnumerator;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.SimpleTypeReference;
import org.exolab.castor.xml.schema.SimpleTypesFactory;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Union;
import org.exolab.castor.xml.schema.XMLType;

public abstract class SimpleType
extends XMLType
implements Referable {
    public static final String FINAL_ALL = "#all";
    public static final String FINAL_LIST = "list";
    public static final String FINAL_UNION = "union";
    public static final String FINAL_RESTRICTION = "restriction";
    private FacetList facets = new FacetList();
    private String _final = null;
    private Structure parent = null;
    private int typeCode = -1;
    private boolean _redefinition = false;

    public void addFacet(Facet facet) {
        if (facet == null) {
            return;
        }
        String name = facet.getName();
        if (name == null) {
            return;
        }
        this.facets.add(facet);
    }

    public Facet getFacet(String name) {
        Enumeration facets = this.getFacets(name);
        if (facets == null) {
            return null;
        }
        return (Facet)facets.nextElement();
    }

    public Enumeration getFacets(String name) {
        FacetListEnumerator fle = null;
        SimpleType datatype = (SimpleType)this.getBaseType();
        if (datatype != null) {
            fle = (FacetListEnumerator)datatype.getFacets(name);
        }
        fle = new FacetListEnumerator(this.facets, fle);
        fle.setMask(name);
        return fle;
    }

    public Enumeration getFacets() {
        FacetListEnumerator fle = null;
        SimpleType datatype = (SimpleType)this.getBaseType();
        if (datatype != null) {
            fle = (FacetListEnumerator)datatype.getFacets();
        }
        fle = new FacetListEnumerator(this.facets, fle);
        return fle;
    }

    public String getFinal() {
        return this._final;
    }

    public Enumeration getLocalFacets() {
        if (this.facets == null) {
            return null;
        }
        return this.facets.enumerate();
    }

    public SimpleType getBuiltInBaseType() {
        SimpleType base;
        for (base = this; base != null && !SimpleTypesFactory.isBuiltInType(base.getTypeCode()) && !(base instanceof Union); base = (SimpleType)base.getBaseType()) {
        }
        return base;
    }

    public Structure getParent() {
        return this.parent;
    }

    public String getReferenceId() {
        return "datatype:" + this.getName();
    }

    public boolean hasFacet(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < this.facets.size(); ++i) {
            Facet facet = this.facets.get(i);
            if (!name.equals(facet.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isBuiltInType() {
        return SimpleTypesFactory.isBuiltInType(this.typeCode);
    }

    public boolean isRedefined() {
        return this._redefinition;
    }

    public void setRedefined() {
        this._redefinition = true;
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    void setTypeCode(int code) {
        this.typeCode = code;
    }

    public Long getLength() {
        Facet lengthFacet = this.getFacet("length");
        if (lengthFacet == null) {
            return null;
        }
        try {
            return new Long(lengthFacet.toLong());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getMinLength() {
        Facet minLengthFacet = this.getFacet("minLength");
        if (minLengthFacet == null) {
            return null;
        }
        try {
            return new Long(minLengthFacet.toLong());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getMaxLength() {
        Facet maxLengthFacet = this.getFacet("maxLength");
        if (maxLengthFacet == null) {
            return null;
        }
        try {
            return new Long(maxLengthFacet.toLong());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean removeFacet(Facet facet) {
        if (facet == null) {
            return false;
        }
        return this.facets.remove(facet);
    }

    public boolean removeFacet(String name) {
        if (name == null) {
            return false;
        }
        for (int i = this.facets.size() - 1; i > 0; --i) {
            Facet facet = this.facets.get(i);
            if (!name.equals(facet.getName())) continue;
            this.facets.remove(i);
            return true;
        }
        return false;
    }

    public void setFinal(String finalValue) {
        if (!(finalValue == null || finalValue.equals(FINAL_ALL) || finalValue.equals(FINAL_UNION) || finalValue.equals(FINAL_LIST) || finalValue.equals(FINAL_RESTRICTION))) {
            String err = "The value '" + finalValue + "' is not a valid" + "value of the final property.";
            throw new IllegalArgumentException(err);
        }
        this._final = finalValue;
    }

    public short getStructureType() {
        return 21;
    }

    public void validate() throws ValidationException {
    }

    protected SimpleType createReference(String name) {
        return new SimpleTypeReference(this.getSchema(), name);
    }

    protected static SimpleType resolveReference(SimpleType simpleType) {
        return (SimpleType)simpleType.getType();
    }

    protected void setParent(Structure parent) {
        this.parent = parent;
    }

    protected void copyFacets(SimpleType target) {
        target.facets.add(this.facets);
    }
}

