/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.XMLType;

class SimpleTypeReference
extends SimpleType {
    private static final long serialVersionUID = 1020507618887404978L;
    private SimpleType referredType = null;

    SimpleTypeReference(Schema schema, String name) {
        if (schema == null) {
            String err = "The schema argument to the constructor of SimpleTypeReference is not allowed to be null.";
            throw new IllegalArgumentException(err);
        }
        if (name == null) {
            String err = "The name argument to the constructor of SimpleTypeReference is not allowed to be null.";
            throw new IllegalArgumentException(err);
        }
        super.setName(name);
        super.setSchema(schema);
    }

    XMLType getType() {
        if (this.referredType == null) {
            this.resolveTypeReference();
        }
        return this.referredType;
    }

    public XMLType getBaseType() {
        return this.getType();
    }

    void resolveTypeReference() {
        this.referredType = this.getSchema().getSimpleType(this.getName());
    }

    public short getStructureType() {
        return -1;
    }

    public void setName(String name) {
        if (name != this.getName()) {
            String err = "The name of a SimpleTypeReference cannot be changed.";
            throw new IllegalStateException(err);
        }
    }

    public void setSchema(Schema schema) {
        if (schema != this.getSchema()) {
            String err = "The Schema of a SimpleTypeReference cannot be changed.";
            throw new IllegalStateException(err);
        }
    }
}

