/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import org.exolab.castor.net.URIException;
import org.exolab.castor.net.URILocation;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.net.util.URILocationImpl;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaLocation;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class ImportUnmarshaller
extends ComponentReader {
    public ImportUnmarshaller(Schema schema, AttributeSet atts, Resolver resolver, URIResolver uriResolver, Locator locator, SchemaUnmarshallerState state) throws XMLException {
        this.setResolver(resolver);
        this.setURIResolver(uriResolver);
        URILocation uri = null;
        String schemaLocation = atts.getValue("schemaLocation");
        String namespace = atts.getValue("namespace");
        if (schemaLocation == null && namespace == null) {
            return;
        }
        boolean hasLocation = schemaLocation != null;
        URIException uriException = null;
        try {
            uri = this.getURIResolver().resolveURN(namespace);
            if (uri != null && !hasLocation) {
                schemaLocation = namespace;
            }
        }
        catch (URIException urix) {
            uriException = urix;
        }
        if (uri == null && hasLocation) {
            if (schemaLocation.indexOf("\\") != -1) {
                String err = "'" + schemaLocation + "' is not a valid URI as defined by IETF RFC 2396.";
                err = err + "The URI mustn't contain '\\'.";
                throw new SchemaException(err);
            }
            if (namespace == null) {
                namespace = "";
            }
            try {
                String documentBase = locator.getSystemId();
                if (documentBase != null && !documentBase.endsWith("/")) {
                    documentBase = documentBase.substring(0, documentBase.lastIndexOf(47) + 1);
                }
                if ((uri = this.getURIResolver().resolve(schemaLocation, documentBase)) != null) {
                    schemaLocation = uri.getAbsoluteURI();
                }
            }
            catch (URIException urix) {
                throw new XMLException(urix);
            }
        }
        if (uri == null) {
            uri = new URILocationImpl(namespace);
            schemaLocation = namespace;
        }
        if (namespace.equals(schema.getTargetNamespace())) {
            throw new SchemaException("the 'namespace' attribute in the <import> element cannot be the same of the targetNamespace of the global schema");
        }
        boolean addSchema = false;
        Schema importedSchema = schema.getImportedSchema(namespace, true);
        if (state.processed(schemaLocation)) {
            if (importedSchema == null) {
                schema.addImportedSchema(state.getSchema(schemaLocation));
            }
            return;
        }
        boolean alreadyLoaded = false;
        if (importedSchema == null) {
            if (uri instanceof SchemaLocation) {
                importedSchema = ((SchemaLocation)uri).getSchema();
                schema.addImportedSchema(importedSchema);
                alreadyLoaded = true;
            } else {
                importedSchema = new Schema();
                addSchema = true;
            }
        } else if (hasLocation) {
            String tmpLocation = importedSchema.getSchemaLocation();
            boolean bl = alreadyLoaded = schemaLocation.equals(tmpLocation) || importedSchema.includeProcessed(schemaLocation);
            if (!alreadyLoaded) {
                importedSchema.addInclude(tmpLocation);
            }
        } else {
            alreadyLoaded = true;
        }
        state.markAsProcessed(schemaLocation, importedSchema);
        if (alreadyLoaded) {
            return;
        }
        Parser parser = null;
        try {
            parser = state.getConfiguration().getParser();
        }
        catch (RuntimeException rte) {
            // empty catch block
        }
        if (parser == null) {
            throw new SchemaException("Error failed to create parser for import");
        }
        SchemaUnmarshaller schemaUnmarshaller = new SchemaUnmarshaller(state);
        schemaUnmarshaller.setURIResolver(this.getURIResolver());
        schemaUnmarshaller.setSchema(importedSchema);
        Sax2ComponentReader handler = new Sax2ComponentReader(schemaUnmarshaller);
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        try {
            InputSource source = new InputSource(uri.getReader());
            source.setSystemId(uri.getAbsoluteURI());
            parser.parse(source);
        }
        catch (IOException ioe) {
            throw new SchemaException("Error reading import file '" + schemaLocation + "': " + ioe);
        }
        catch (SAXException sx) {
            throw new SchemaException(sx);
        }
        if (addSchema) {
            importedSchema.setSchemaLocation(schemaLocation);
            schema.addImportedSchema(importedSchema);
        }
    }

    public String elementName() {
        return "import";
    }

    public Object getObject() {
        return null;
    }
}

