/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.lang.reflect.Array;
import java.util.Collection;
import org.exolab.castor.mapping.AbstractFieldHandler;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.xml.FieldValidator;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XMLNaming;
import org.exolab.castor.xml.util.XMLFieldDescriptors;

public class XMLClassDescriptorImpl
extends Validator
implements XMLClassDescriptor {
    private static final short ALL = 0;
    private static final short CHOICE = 1;
    private static final short SEQUENCE = 2;
    private static final String NULL_CLASS_ERR = "The Class passed as an argument to the constructor of XMLClassDescriptorImpl may not be null.";
    private static final String WILDCARD = "*";
    private static XMLNaming _naming = null;
    private XMLFieldDescriptors _attributes = new XMLFieldDescriptors(5);
    private XMLFieldDescriptor[] _attArray = null;
    private Class _class = null;
    private int _containerCount = 0;
    private XMLFieldDescriptor contentDescriptor = null;
    private TypeValidator validator = null;
    private XMLFieldDescriptors _elements = new XMLFieldDescriptors(7);
    private XMLFieldDescriptor[] _elemArray = null;
    private String nsPrefix = null;
    private String nsURI = null;
    private String _xmlName;
    private boolean elementDefinition = false;
    private XMLClassDescriptor _extends;
    private FieldDescriptor _identity;
    private AccessMode _accessMode;
    private boolean _introspected = false;
    private short _compositor = 0;

    public XMLClassDescriptorImpl(Class type) {
        this();
        if (type == null) {
            throw new IllegalArgumentException(NULL_CLASS_ERR);
        }
        this._class = type;
        this.setXMLName(null);
    }

    public XMLClassDescriptorImpl(Class type, String xmlName) {
        this();
        if (type == null) {
            throw new IllegalArgumentException(NULL_CLASS_ERR);
        }
        this._class = type;
        this.setXMLName(xmlName);
    }

    protected XMLClassDescriptorImpl() {
    }

    public void addFieldDescriptor(XMLFieldDescriptor descriptor) {
        this.addFieldDescriptor(descriptor, true);
    }

    public boolean contains(XMLFieldDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        if (this._attributes.contains(descriptor)) {
            return true;
        }
        if (this._elements.contains(descriptor)) {
            return true;
        }
        return descriptor.equals(this.contentDescriptor);
    }

    public XMLFieldDescriptor[] getAttributeDescriptors() {
        return (XMLFieldDescriptor[])this.getAttributeArray().clone();
    }

    public XMLFieldDescriptor getContentDescriptor() {
        return this.contentDescriptor;
    }

    public XMLFieldDescriptor[] getElementDescriptors() {
        return (XMLFieldDescriptor[])this.getElementArray().clone();
    }

    public XMLFieldDescriptor getFieldDescriptor(String name, String namespace, NodeType nodeType) {
        XMLClassDescriptor xcd;
        XMLFieldDescriptor desc;
        int i;
        int idx;
        boolean wild = nodeType == null || this._introspected;
        XMLFieldDescriptor result = null;
        XMLFieldDescriptor[] attributes = this._attArray;
        XMLFieldDescriptor[] elements = this._elemArray;
        String location = null;
        if (name != null && (idx = name.lastIndexOf(47)) >= 0) {
            location = name.substring(0, idx);
            name = name.substring(idx + 1);
        }
        if (wild || nodeType == NodeType.Element) {
            if (elements == null) {
                elements = this.getElementArray();
            }
            for (i = 0; i < elements.length; ++i) {
                desc = elements[i];
                if (desc == null || location != null && !location.equals(desc.getLocationPath())) continue;
                if (desc.matches(name)) {
                    if (!desc.matches(WILDCARD)) {
                        return desc;
                    }
                    if (name.equals(desc.getXMLName())) {
                        return desc;
                    }
                    result = desc;
                }
                if (!desc.isContainer() || (xcd = (XMLClassDescriptor)desc.getClassDescriptor()) == this || xcd.getFieldDescriptor(name, namespace, NodeType.Element) == null) continue;
                result = desc;
                break;
            }
            if (result != null) {
                return result;
            }
        }
        if (wild || nodeType == NodeType.Attribute) {
            if (attributes == null) {
                attributes = this.getAttributeArray();
            }
            for (i = 0; i < attributes.length; ++i) {
                desc = attributes[i];
                if (desc == null || !desc.matches(name)) continue;
                return desc;
            }
        }
        if (nodeType == NodeType.Namespace) {
            if (attributes == null) {
                attributes = this.getAttributeArray();
            }
            for (i = 0; i < attributes.length; ++i) {
                if (attributes[i] == null || attributes[i].getNodeType() != NodeType.Namespace) continue;
                return attributes[i];
            }
        }
        if (nodeType == NodeType.Attribute) {
            if (elements == null) {
                elements = this.getElementArray();
            }
            for (i = 0; i < elements.length; ++i) {
                XMLFieldDescriptor temp;
                desc = elements[i];
                if (!desc.isContainer() || (xcd = (XMLClassDescriptor)desc.getClassDescriptor()) == this || (temp = xcd.getFieldDescriptor(name, namespace, NodeType.Attribute)) == null) continue;
                return desc;
            }
        }
        return null;
    }

    public String getNameSpacePrefix() {
        return this.nsPrefix;
    }

    public String getNameSpaceURI() {
        return this.nsURI;
    }

    public TypeValidator getValidator() {
        if (this.validator != null) {
            return this.validator;
        }
        return this;
    }

    public String getXMLName() {
        return this._xmlName;
    }

    public boolean isElementDefinition() {
        return this.elementDefinition;
    }

    public boolean hasContainerFields() {
        return this._containerCount > 0;
    }

    public boolean removeFieldDescriptor(XMLFieldDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        boolean removed = false;
        NodeType nodeType = descriptor.getNodeType();
        switch (nodeType.getType()) {
            case 0: 
            case 2: {
                if (!this._attributes.remove(descriptor)) break;
                removed = true;
                this._attArray = null;
                break;
            }
            case 3: {
                if (this.contentDescriptor != descriptor) break;
                this.contentDescriptor = null;
                removed = true;
                break;
            }
            default: {
                if (!this._elements.remove(descriptor)) break;
                this._elemArray = null;
                removed = true;
                if (!descriptor.isContainer()) break;
                --this._containerCount;
            }
        }
        return removed;
    }

    public void setCompositorAsAll() {
        this._compositor = 0;
    }

    public void setCompositorAsChoice() {
        this._compositor = 1;
    }

    public void setCompositorAsSequence() {
        this._compositor = (short)2;
    }

    public void setExtends(XMLClassDescriptor classDesc) {
        int i;
        FieldDescriptor[] fields = null;
        if (this._extends != null) {
            this.sortDescriptors();
            fields = this._extends.getFields();
            for (i = 0; i < fields.length; ++i) {
                this.removeFieldDescriptor((XMLFieldDescriptor)fields[i]);
            }
        }
        this._extends = classDesc;
        if (this._extends != null) {
            fields = classDesc.getFields();
            for (i = 0; i < fields.length; ++i) {
                this.addFieldDescriptor((XMLFieldDescriptor)fields[i], false);
            }
        }
    }

    public void setIdentity(XMLFieldDescriptor fieldDesc) {
        if (fieldDesc != null && !this._attributes.contains(fieldDesc) && !this._elements.contains(fieldDesc)) {
            this.addFieldDescriptor(fieldDesc);
        }
        this._identity = fieldDesc;
    }

    public void setNameSpacePrefix(String nsPrefix) {
        this.nsPrefix = nsPrefix;
    }

    public void setNameSpaceURI(String nsURI) {
        this.nsURI = nsURI;
    }

    public void setXMLName(String xmlName) {
        if (xmlName == null) {
            if (this._class != null) {
                this._xmlName = this.toXMLName(this._class.getName());
            }
        } else {
            this._xmlName = xmlName;
        }
    }

    public void setElementDefinition(boolean elementDefinition) {
        this.elementDefinition = elementDefinition;
    }

    public void sortDescriptors() {
        XMLFieldDescriptor fieldDesc;
        int i;
        XMLFieldDescriptor[] descriptors = this.getAttributeArray();
        block8: for (i = 0; i < descriptors.length; ++i) {
            fieldDesc = descriptors[i];
            switch (fieldDesc.getNodeType().getType()) {
                case 1: {
                    this._elements.add(fieldDesc);
                    this._attributes.remove(fieldDesc);
                    this._attArray = null;
                    continue block8;
                }
                case 3: {
                    this._attributes.remove(fieldDesc);
                    this._attArray = null;
                    continue block8;
                }
            }
        }
        descriptors = this.getElementArray();
        block9: for (i = 0; i < descriptors.length; ++i) {
            fieldDesc = descriptors[i];
            switch (fieldDesc.getNodeType().getType()) {
                case 0: 
                case 2: {
                    this._attributes.add(fieldDesc);
                    this._elements.remove(fieldDesc);
                    this._elemArray = null;
                    continue block9;
                }
                case 3: {
                    this._elements.remove(fieldDesc);
                    this._elemArray = null;
                    continue block9;
                }
            }
        }
    }

    public String toString() {
        String str = super.toString() + "; descriptor for class: ";
        str = this._class != null ? str + this._class.getName() : str + "[null]";
        str = str + "; xml name: " + this._xmlName;
        return str;
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        XMLFieldDescriptor desc;
        int i;
        if (object == null) {
            throw new ValidationException("Cannot validate a null object.");
        }
        if (!this.getJavaClass().isAssignableFrom(object.getClass())) {
            String err = "The given object is not an instance of the class described by this ClassDecriptor.";
            throw new ValidationException(err);
        }
        XMLFieldDescriptor[] localElements = this.getElementArray();
        if (this._extends != null) {
            if (this._extends instanceof XMLClassDescriptorImpl) {
                ((XMLClassDescriptorImpl)this._extends).validate(object, context);
            } else {
                TypeValidator validator = this._extends.getValidator();
                if (validator != null) {
                    validator.validate(object, context);
                }
            }
            XMLFieldDescriptor[] inherited = this._extends.getElementDescriptors();
            XMLFieldDescriptor[] allElements = localElements;
            localElements = new XMLFieldDescriptor[allElements.length - inherited.length];
            int localIdx = 0;
            for (i = 0; i < allElements.length; ++i) {
                desc = allElements[i];
                boolean isInherited = false;
                for (int idx = 0; idx < inherited.length; ++idx) {
                    if (!inherited[idx].equals(desc)) continue;
                    isInherited = true;
                    break;
                }
                if (isInherited) continue;
                localElements[localIdx] = desc;
                ++localIdx;
            }
        }
        switch (this._compositor) {
            case 1: {
                FieldValidator fieldValidator;
                boolean found = false;
                boolean hasLocalDescs = localElements.length > 0;
                XMLFieldDescriptor fieldDesc = null;
                for (i = 0; i < localElements.length; ++i) {
                    FieldHandler handler;
                    desc = localElements[i];
                    if (desc == null || (handler = desc.getHandler()).getValue(object) == null) continue;
                    if (desc.isMultivalued()) {
                        Object temp = handler.getValue(object);
                        if (Array.getLength(temp) == 0) {
                            temp = null;
                            continue;
                        }
                        temp = null;
                    }
                    if (found) {
                        String err = null;
                        if (desc.isContainer()) {
                            err = "The group '" + desc.getFieldName();
                            err = err + "' cannot exist at the same time that ";
                            err = fieldDesc.isContainer() ? err + "the group '" + fieldDesc.getFieldName() : err + "the element '" + fieldDesc.getXMLName();
                            err = err + "' also exists.";
                        } else {
                            err = "The element '" + desc.getXMLName();
                            err = err + "' cannot exist at the same time that ";
                            err = err + "element '" + fieldDesc.getXMLName() + "' also exists.";
                        }
                        throw new ValidationException(err);
                    }
                    found = true;
                    fieldDesc = desc;
                    FieldValidator fieldValidator2 = desc.getValidator();
                    if (fieldValidator2 == null) continue;
                    fieldValidator2.validate(object, context);
                }
                if (!found && hasLocalDescs) {
                    StringBuffer buffer = new StringBuffer(40);
                    boolean error = false;
                    buffer.append('(');
                    String sep = " | ";
                    for (int i2 = 0; i2 < localElements.length; ++i2) {
                        FieldValidator fieldValidator3;
                        XMLFieldDescriptor desc2 = localElements[i2];
                        if (desc2 == null || (fieldValidator3 = desc2.getValidator()).getMinOccurs() <= 0) continue;
                        if (error) {
                            buffer.append(sep);
                        } else {
                            error = true;
                        }
                        buffer.append(desc2.getXMLName());
                    }
                    buffer.append(')');
                    if (error) {
                        String err = "In the choice contained in <" + this.getXMLName() + ">, at least one of these elements must appear:\n" + buffer.toString();
                        throw new ValidationException(err);
                    }
                }
                for (int i3 = 0; i3 < this._attributes.size(); ++i3) {
                    FieldValidator fieldValidator4 = this._attributes.get(i3).getValidator();
                    if (fieldValidator4 == null) continue;
                    fieldValidator4.validate(object, context);
                }
                if (this.contentDescriptor == null || (fieldValidator = this.contentDescriptor.getValidator()) == null) break;
                fieldValidator.validate(object, context);
                break;
            }
            default: {
                FieldValidator fieldValidator;
                FieldValidator fieldValidator5;
                for (i = 0; i < localElements.length; ++i) {
                    if (localElements[i] == null || (fieldValidator5 = localElements[i].getValidator()) == null) continue;
                    fieldValidator5.validate(object, context);
                }
                for (i = 0; i < this._attributes.size(); ++i) {
                    fieldValidator5 = this._attributes.get(i).getValidator();
                    if (fieldValidator5 == null) continue;
                    fieldValidator5.validate(object, context);
                }
                if (this.contentDescriptor == null || (fieldValidator = this.contentDescriptor.getValidator()) == null) break;
                fieldValidator.validate(object, context);
            }
        }
    }

    public Class getJavaClass() {
        return this._class;
    }

    public FieldDescriptor[] getFields() {
        int size = this._attributes.size();
        size += this._elements.size();
        if (this.contentDescriptor != null) {
            ++size;
        }
        XMLFieldDescriptor[] fields = new XMLFieldDescriptor[size];
        this._attributes.toArray(fields);
        this._elements.toArray(fields, this._attributes.size());
        if (this.contentDescriptor != null) {
            fields[size - 1] = this.contentDescriptor;
        }
        return fields;
    }

    public ClassDescriptor getExtends() {
        return this._extends;
    }

    public FieldDescriptor getIdentity() {
        return this._identity;
    }

    public AccessMode getAccessMode() {
        return this._accessMode;
    }

    public boolean canAccept(String name, String namespace, Object object) {
        Object tempObject;
        boolean result = false;
        boolean hasValue = false;
        XMLFieldDescriptor[] fields = null;
        int i = 0;
        XMLFieldDescriptor fieldDesc = this.getFieldDescriptor(name, namespace, NodeType.Element);
        if (fieldDesc == null) {
            fieldDesc = this.getFieldDescriptor(name, namespace, NodeType.Attribute);
        }
        if (fieldDesc == null) {
            return false;
        }
        if (fieldDesc.isMultivalued()) {
            int current;
            int newTotal;
            FieldValidator validator = fieldDesc.getValidator();
            result = validator != null ? (validator.getMaxOccurs() < 0 ? true : (newTotal = (current = Array.getLength(tempObject = fieldDesc.getHandler().getValue(object))) + 1) <= validator.getMaxOccurs()) : true;
        } else if (fieldDesc.isContainer()) {
            tempObject = fieldDesc.getHandler().getValue(object);
            result = tempObject == null ? true : ((XMLClassDescriptor)fieldDesc.getClassDescriptor()).canAccept(name, namespace, tempObject);
        } else {
            FieldHandler handler = fieldDesc.getHandler();
            boolean checkPrimitiveValue = true;
            if (handler instanceof AbstractFieldHandler) {
                hasValue = ((AbstractFieldHandler)handler).hasValue(object);
            } else {
                boolean bl = hasValue = handler.getValue(object) != null;
            }
            if (!hasValue || !checkPrimitiveValue || fieldDesc.getFieldType().isPrimitive()) {
                // empty if block
            }
            if (XMLClassDescriptorImpl.isDefaultPrimitiveValue(handler.getValue(object))) {
                hasValue = false;
            }
            boolean bl = result = !hasValue;
        }
        if (result && this._compositor == 1 && fieldDesc.getNodeType() == NodeType.Element) {
            fields = this.getElementArray();
            for (i = 0; result && i < fields.length; ++i) {
                XMLFieldDescriptor desc = fields[i];
                if (desc == fieldDesc || object == null) continue;
                Object tempObj = desc.getHandler().getValue(object);
                boolean bl = hasValue = tempObj != null;
                if (!hasValue) continue;
                result = false;
                if (tempObj.getClass().isArray()) {
                    boolean bl2 = result = Array.getLength(tempObj) == 0;
                }
                if (!(tempObj instanceof Collection)) continue;
                result = ((Collection)tempObj).isEmpty();
            }
        }
        return result;
    }

    static boolean isPrimitive(Class type) {
        if (type == null) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type == Boolean.class || type == Character.class) {
            return true;
        }
        return type.getSuperclass() == Number.class;
    }

    static boolean isDefaultPrimitiveValue(Object value) {
        block8: {
            if (value == null) {
                return false;
            }
            Class<?> type = value.getClass();
            if (type.isPrimitive()) {
                try {
                    return value.equals(type.newInstance());
                }
                catch (IllegalAccessException iax) {
                    break block8;
                }
                catch (InstantiationException instantiationException) {
                    break block8;
                }
            }
            if (type.getSuperclass() == Number.class) {
                return ((Number)value).intValue() == 0;
            }
            if (type == Boolean.class) {
                return value.equals(Boolean.FALSE);
            }
            if (type == Character.class) {
                return ((Character)value).charValue() == '\u0000';
            }
        }
        return false;
    }

    protected void setJavaClass(Class type) {
        this._class = type;
    }

    protected void setExtendsWithoutFlatten(XMLClassDescriptor classDesc) {
        this._extends = classDesc;
    }

    protected void setIntrospected(boolean introspected) {
        this._introspected = introspected;
    }

    protected String toXMLName(String className) {
        String name = className;
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        return _naming.toXMLName(name);
    }

    private void addFieldDescriptor(XMLFieldDescriptor descriptor, boolean relink) {
        if (descriptor == null) {
            return;
        }
        boolean added = false;
        NodeType nodeType = descriptor.getNodeType();
        switch (nodeType.getType()) {
            case 0: 
            case 2: {
                added = this._attributes.add(descriptor);
                if (!added) break;
                this._attArray = null;
                break;
            }
            case 3: {
                this.contentDescriptor = descriptor;
                added = true;
                break;
            }
            default: {
                added = this._elements.add(descriptor);
                if (!added) break;
                this._elemArray = null;
                if (!descriptor.isContainer()) break;
                ++this._containerCount;
            }
        }
        if (added && relink) {
            descriptor.setContainingClassDescriptor(this);
        }
    }

    private XMLFieldDescriptor[] getAttributeArray() {
        XMLFieldDescriptor[] descriptors = this._attArray;
        if (descriptors == null) {
            descriptors = this._attributes.toArray();
            this._attArray = descriptors;
        }
        return descriptors;
    }

    private XMLFieldDescriptor[] getElementArray() {
        XMLFieldDescriptor[] descriptors = this._elemArray;
        if (descriptors == null) {
            descriptors = this._elements.toArray();
            this._elemArray = descriptors;
        }
        return descriptors;
    }

    static {
        _naming = XMLNaming.getInstance();
    }
}

