/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.io.PrintWriter;
import org.exolab.castor.util.OrderedHashMap;
import org.exolab.javasource.JAnnotatedElement;
import org.exolab.javasource.JAnnotation;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JConstructor;
import org.exolab.javasource.JField;
import org.exolab.javasource.JInterface;
import org.exolab.javasource.JMethod;
import org.exolab.javasource.JMethodSignature;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JStructure;
import org.exolab.javasource.JType;

public class JAnnotatedElementHelper
implements JAnnotatedElement {
    private OrderedHashMap _annotations;

    public JAnnotation getAnnotation(JAnnotationType annotationType) {
        if (this._annotations == null) {
            return null;
        }
        return (JAnnotation)this._annotations.get(annotationType.getName());
    }

    public JAnnotation[] getAnnotations() {
        if (this._annotations == null) {
            return new JAnnotation[0];
        }
        return this._annotations.values().toArray(new JAnnotation[0]);
    }

    public boolean isAnnotationPresent(JAnnotationType annotationType) {
        if (this._annotations != null) {
            return this._annotations.containsKey(annotationType.getName());
        }
        return false;
    }

    public void addAnnotation(JAnnotation annotation) {
        if (this.isAnnotationPresent(annotation.getAnnotationType())) {
            throw new IllegalArgumentException("Annotation for '" + annotation.getAnnotationType().getName() + "' already added.");
        }
        String annotationType = annotation.getAnnotationType().getName();
        if (this._annotations == null) {
            this._annotations = new OrderedHashMap();
        }
        this._annotations.put(annotationType, annotation);
    }

    public JAnnotation removeAnnotation(JAnnotationType annotationType) {
        if (!this.isAnnotationPresent(annotationType)) {
            throw new IllegalArgumentException("Annotation for '" + annotationType.getName() + "' not present.");
        }
        return (JAnnotation)this._annotations.remove(annotationType.getName());
    }

    public boolean hasAnnotations() {
        if (this._annotations != null) {
            return this._annotations.size() > 0;
        }
        return false;
    }

    public boolean printAnnotations(JSourceWriter jsw) {
        boolean printed = false;
        if (this._annotations != null) {
            for (JAnnotation annotation : this._annotations.values()) {
                annotation.print(jsw);
                jsw.writeln();
                printed = true;
            }
        }
        return printed;
    }

    public static void main(String[] args) {
        JSourceWriter jsw = new JSourceWriter(new PrintWriter(System.out));
        JStructure lollipop = new JClass("Lollipop");
        JAnnotationType endorsersType = new JAnnotationType("org.xyz.Endorsers");
        JAnnotation endorsers = new JAnnotation(endorsersType);
        endorsers.setValue(new String[]{"\"Children\"", "\"Unscrupulous dentists\""});
        lollipop.addAnnotation(endorsers);
        ((JClass)lollipop).print(jsw);
        jsw.writeln();
        jsw.writeln();
        JAnnotationType copyrightType = new JAnnotationType("org.xyz.Copyright");
        JAnnotation copyright = new JAnnotation(copyrightType);
        copyright.setValue("\"2002 Yoyodyne Propulsion Systems, Inc., All rights reserved.\"");
        JClass lollipop2 = new JClass("Lollipop");
        JAnnotationType endorsersType2 = new JAnnotationType("org.xyz.Endorsers");
        JAnnotation endorsers2 = new JAnnotation(endorsersType2);
        endorsers2.setValue(new String[]{"\"Children\"", "\"Unscrupulous dentists\""});
        lollipop2.addAnnotation(endorsers2);
        lollipop2.addAnnotation(copyright);
        lollipop2.print(jsw);
        jsw.writeln();
        jsw.writeln();
        lollipop = new JInterface("Lollipop");
        endorsersType = new JAnnotationType("org.xyz.Endorsers");
        endorsers = new JAnnotation(endorsersType);
        endorsers.setValue(new String[]{"\"Children\"", "\"Unscrupulous dentists\""});
        lollipop.addAnnotation(endorsers);
        ((JInterface)lollipop).print(jsw);
        jsw.writeln();
        jsw.writeln();
        JStructure timeMachine = new JClass("EventProducer");
        JAnnotationType suppressWarningsType = new JAnnotationType("org.xyz.SuppressWarnings");
        JAnnotation suppressWarnings = new JAnnotation(suppressWarningsType);
        JField field = new JField(new JClass("DocumentHandler"), "documentHandler");
        field.addAnnotation(suppressWarnings);
        ((JClass)timeMachine).addField(field);
        ((JClass)timeMachine).print(jsw);
        jsw.writeln();
        jsw.writeln();
        timeMachine = new JInterface("TimeMachine");
        suppressWarningsType = new JAnnotationType("SuppressWarnings");
        suppressWarnings = new JAnnotation(suppressWarningsType);
        field = new JField(new JClass("DocumentHandler"), "documentHandler");
        field.getModifiers().setStatic(true);
        field.getModifiers().makePublic();
        field.addAnnotation(suppressWarnings);
        ((JInterface)timeMachine).addField(field);
        ((JInterface)timeMachine).print(jsw);
        jsw.writeln();
        jsw.writeln();
        timeMachine = new JClass("TimeMachine");
        JAnnotationType requestForEnhancementType = new JAnnotationType("org.xyz.RequestForEnhancement");
        JAnnotation requestForEnhancement = new JAnnotation(requestForEnhancementType);
        requestForEnhancement.setElementValue("id", "2868724");
        requestForEnhancement.setElementValue("sysopsis", "\"Provide time-travel functionality\"");
        requestForEnhancement.setElementValue("enginer", "\"Mr. Peabody\"");
        requestForEnhancement.setElementValue("date", "\"4/1/2004\"");
        JAnnotatedElement travelThroughTime = new JMethod(null, "travelThroughTime");
        ((JMethod)travelThroughTime).addAnnotation(requestForEnhancement);
        ((JMethod)travelThroughTime).addParameter(new JParameter(new JClass("Date"), "date"));
        ((JClass)timeMachine).addMethod((JMethod)travelThroughTime);
        ((JClass)timeMachine).print(jsw);
        jsw.writeln();
        jsw.writeln();
        timeMachine = new JInterface("TimeMachine");
        requestForEnhancementType = new JAnnotationType("RequestForEnhancement");
        requestForEnhancement = new JAnnotation(requestForEnhancementType);
        requestForEnhancement.setElementValue("id", "2868724");
        requestForEnhancement.setElementValue("sysopsis", "\"Provide time-travel functionality\"");
        requestForEnhancement.setElementValue("enginer", "\"Mr. Peabody\"");
        requestForEnhancement.setElementValue("date", "\"4/1/2004\"");
        travelThroughTime = new JMethodSignature("travelThroughTime", null);
        ((JAnnotatedElementHelper)travelThroughTime).addAnnotation(requestForEnhancement);
        ((JMethodSignature)travelThroughTime).addParameter(new JParameter(new JClass("Date"), "date"));
        ((JInterface)timeMachine).addMethod((JMethodSignature)travelThroughTime);
        ((JInterface)timeMachine).print(jsw);
        jsw.writeln();
        jsw.writeln();
        lollipop = new JClass("Lollipop");
        endorsersType = new JAnnotationType("Endorsers");
        endorsers = new JAnnotation(endorsersType);
        endorsers.setValue(new String[]{"\"Children\"", "\"Unscrupulous dentists\""});
        JConstructor constructor = new JConstructor((JClass)lollipop);
        constructor.addAnnotation(endorsers);
        ((JClass)lollipop).addConstructor(constructor);
        ((JClass)lollipop).print(jsw);
        jsw.writeln();
        jsw.writeln();
        timeMachine = new JInterface("EventProducer");
        suppressWarningsType = new JAnnotationType("org.xyz.SuppressWarnings");
        suppressWarnings = new JAnnotation(suppressWarningsType);
        travelThroughTime = new JMethodSignature("produceEvents", null);
        JParameter parameter = new JParameter(new JClass("DocumentHandler"), "documentHandler");
        parameter.addAnnotation(suppressWarnings);
        ((JMethodSignature)travelThroughTime).addParameter(parameter);
        JParameter parameter1 = new JParameter(JType.Boolean, "asDocument");
        ((JMethodSignature)travelThroughTime).addParameter(parameter1);
        ((JInterface)timeMachine).addMethod((JMethodSignature)travelThroughTime);
        ((JInterface)timeMachine).print(jsw);
        jsw.writeln();
        jsw.writeln();
        lollipop = new JClass("Lollipop");
        JConstructor constructor2 = new JConstructor((JClass)lollipop);
        JAnnotationType suppressWarningsType2 = new JAnnotationType("SuppressWarnings");
        JAnnotation suppressWarnings2 = new JAnnotation(suppressWarningsType2);
        parameter = new JParameter(new JClass("DocumentHandler"), "documentHandler");
        parameter.addAnnotation(suppressWarnings2);
        constructor2.addParameter(parameter);
        parameter1 = new JParameter(JType.Boolean, "asDocument");
        constructor2.addParameter(parameter1);
        ((JClass)lollipop).addConstructor(constructor2);
        ((JClass)lollipop).print(jsw);
        jsw.flush();
    }
}

