/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.common.resourceutilities;

import com.softwareag.common.resourceutilities.ResourceLocator;
import com.softwareag.common.resourceutilities.SoftCache;
import com.softwareag.common.resourceutilities.XMLResourceBundleFailureHandler;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractXMLBasedResourceBundle
extends ResourceBundle {
    private static final String LOG_NAME;
    private static Logger logger;
    protected static SoftCache cache;
    protected Map resourceMap = null;
    protected Locale locale = null;
    protected URL resourceURL = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractXMLBasedResourceBundle() {
    }

    protected AbstractXMLBasedResourceBundle(URL uRL, Locale locale) throws SAXException, ParserConfigurationException, IOException {
        this.resourceURL = uRL;
        this.locale = locale;
        this.parseResource();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public URL getResourceURL() {
        return this.resourceURL;
    }

    public Object handleGetObject(String string) {
        Object object = null;
        if (this.resourceMap != null) {
            object = this.resourceMap.get(string);
        }
        AbstractXMLBasedResourceBundle abstractXMLBasedResourceBundle = (AbstractXMLBasedResourceBundle)this.parent;
        if (object == null && abstractXMLBasedResourceBundle != null) {
            object = abstractXMLBasedResourceBundle.handleGetObject(string);
        }
        return object;
    }

    public Enumeration getKeys() {
        if (this.resourceMap == null) {
            this.resourceMap = new HashMap();
        }
        return Collections.enumeration(this.resourceMap.keySet());
    }

    protected void put(String string, String string2) {
        if (this.resourceMap == null) {
            this.resourceMap = new HashMap();
        }
        if (string2 == null) {
            this.remove(string);
        } else {
            this.resourceMap.put(string, string2);
        }
    }

    protected String remove(String string) {
        String string2 = null;
        if (this.resourceMap != null) {
            string2 = (String)this.resourceMap.remove(string);
        }
        return string2;
    }

    protected static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader, XMLResourceBundleFailureHandler xMLResourceBundleFailureHandler, XMLBasedResourceBundleFactory xMLBasedResourceBundleFactory) throws MissingResourceException {
        if (!$assertionsDisabled && xMLBasedResourceBundleFactory == null) {
            throw new AssertionError((Object)"Parameter 'resourceBundleFactory' must not be null");
        }
        AbstractXMLBasedResourceBundle abstractXMLBasedResourceBundle = null;
        Iterator iterator = ResourceLocator.getAllResourceLocations(string, "xml", locale, classLoader).iterator();
        if (iterator.hasNext()) {
            AbstractXMLBasedResourceBundle abstractXMLBasedResourceBundle2 = abstractXMLBasedResourceBundle = AbstractXMLBasedResourceBundle.getBundle((ResourceLocator.ResourceLocation)iterator.next(), xMLResourceBundleFailureHandler, xMLBasedResourceBundleFactory);
            AbstractXMLBasedResourceBundle abstractXMLBasedResourceBundle3 = null;
            while (abstractXMLBasedResourceBundle2 != null && abstractXMLBasedResourceBundle2.parent == null && iterator.hasNext()) {
                abstractXMLBasedResourceBundle3 = AbstractXMLBasedResourceBundle.getBundle((ResourceLocator.ResourceLocation)iterator.next(), xMLResourceBundleFailureHandler, xMLBasedResourceBundleFactory);
                abstractXMLBasedResourceBundle2.setParent(abstractXMLBasedResourceBundle3);
                abstractXMLBasedResourceBundle2 = abstractXMLBasedResourceBundle3;
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Resource '" + string + "' could not be found");
            }
            if (xMLResourceBundleFailureHandler != null) {
                xMLResourceBundleFailureHandler.handleResourceBundleNotFound(string, locale, classLoader);
            }
        }
        return abstractXMLBasedResourceBundle;
    }

    private static AbstractXMLBasedResourceBundle getBundle(ResourceLocator.ResourceLocation resourceLocation, XMLResourceBundleFailureHandler xMLResourceBundleFailureHandler, XMLBasedResourceBundleFactory xMLBasedResourceBundleFactory) throws MissingResourceException {
        AbstractXMLBasedResourceBundle abstractXMLBasedResourceBundle;
        block13: {
            abstractXMLBasedResourceBundle = null;
            if (resourceLocation != null) {
                if (cache != null) {
                    abstractXMLBasedResourceBundle = (AbstractXMLBasedResourceBundle)cache.get(resourceLocation);
                }
                if (abstractXMLBasedResourceBundle == null) {
                    try {
                        abstractXMLBasedResourceBundle = xMLBasedResourceBundleFactory.createXMLResourceBundle(resourceLocation.getURL(), resourceLocation.getLocale());
                        if (cache == null) {
                            cache = new SoftCache();
                        }
                        cache.put(resourceLocation, abstractXMLBasedResourceBundle);
                    }
                    catch (SAXException sAXException) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.throwing(LOG_NAME, "Failed parsing resource file " + resourceLocation.getURL(), sAXException);
                        }
                        if (xMLResourceBundleFailureHandler != null) {
                            xMLResourceBundleFailureHandler.handleParseException(sAXException, resourceLocation);
                        }
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.throwing(LOG_NAME, "Failed parsing resource file " + resourceLocation.getURL(), parserConfigurationException);
                        }
                        if (xMLResourceBundleFailureHandler != null) {
                            xMLResourceBundleFailureHandler.handleParseException(parserConfigurationException, resourceLocation);
                        }
                    }
                    catch (IOException iOException) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.throwing(LOG_NAME, "Failed parsing resource file " + resourceLocation.getURL(), iOException);
                        }
                        if (xMLResourceBundleFailureHandler == null) break block13;
                        xMLResourceBundleFailureHandler.handleParseException(iOException, resourceLocation);
                    }
                }
            }
        }
        return abstractXMLBasedResourceBundle;
    }

    protected void parseResource() throws SAXException, ParserConfigurationException, IOException {
        SAXParser sAXParser = null;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        sAXParserFactory.setValidating(false);
        sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(this.getResourceURL().toString(), this.getDefaultHandler());
    }

    protected abstract DefaultHandler getDefaultHandler();

    public String toString() {
        if (this.resourceMap == null) {
            this.resourceMap = new HashMap();
        }
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(this.resourceMap.toString());
        return stringBuffer.toString();
    }

    static {
        $assertionsDisabled = !AbstractXMLBasedResourceBundle.class.desiredAssertionStatus();
        LOG_NAME = AbstractXMLBasedResourceBundle.class.getName();
        logger = Logger.getLogger(LOG_NAME);
        cache = null;
    }

    public static interface XMLBasedResourceBundleFactory {
        public AbstractXMLBasedResourceBundle createXMLResourceBundle(URL var1, Locale var2) throws SAXException, ParserConfigurationException, IOException;
    }
}

