/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.common.resourceutilities;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SoftCache {
    protected Map map = new HashMap();
    protected ReferenceQueue referenceQueue = new ReferenceQueue();
    private Set polledReferencesSet = new HashSet(10);

    public synchronized Object get(Object object) {
        this.updateCache();
        Object var2_2 = null;
        SoftReference softReference = (SoftReference)this.map.get(object);
        if (softReference != null) {
            var2_2 = softReference.get();
        }
        return var2_2;
    }

    public synchronized void put(Object object, Object object2) {
        this.updateCache();
        if (object2 == null) {
            this.map.remove(object);
        } else {
            this.map.put(object, new SoftReference<Object>(object2, this.referenceQueue));
        }
    }

    public synchronized void clear() {
        while (this.referenceQueue.poll() != null) {
        }
        this.map.clear();
    }

    public synchronized int size() {
        this.updateCache();
        return this.map.size();
    }

    protected void updateCache() {
        Reference reference = this.referenceQueue.poll();
        while (reference != null) {
            this.polledReferencesSet.add(reference);
            reference = this.referenceQueue.poll();
        }
        if (this.polledReferencesSet.size() > 0) {
            Iterator iterator = this.map.entrySet().iterator();
            Map.Entry entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                if (!this.polledReferencesSet.contains(entry.getValue())) continue;
                iterator.remove();
            }
            this.polledReferencesSet.clear();
        }
    }
}

