/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.common.resourceutilities;

import com.softwareag.common.resourceutilities.AbstractXMLBasedResourceBundle;
import com.softwareag.common.resourceutilities.XMLResourceBundleFailureHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLResourceBundle
extends AbstractXMLBasedResourceBundle {
    public static final String PROPERTIES_TAG = "properties";
    public static final String PROPERTY_TAG = "property";
    public static final String KEY_ATTRIBUTE = "key";
    public static final String KEY_ATTRIBUTE_MISSING = "Attribute 'key' of element <property> must be set";
    public static final String ROOT_MUST_BE_PROPERTIES = "The first node must be  a <properties> element";
    protected static XMLResourceBundleFactory factory = new XMLResourceBundleFactory();
    protected static DocumentBuilderFactory documentBuilderFactory = null;
    protected static TransformerFactory transformerFactory = null;

    public XMLResourceBundle() {
    }

    public XMLResourceBundle(URL uRL) throws SAXException, ParserConfigurationException, IOException {
        this(uRL, null);
    }

    public XMLResourceBundle(Source source) throws SAXException, ParserConfigurationException, IOException, TransformerConfigurationException, TransformerException {
        this.newTransformer().transform(source, new SAXResult(this.getDefaultHandler()));
    }

    protected XMLResourceBundle(URL uRL, Locale locale) throws SAXException, ParserConfigurationException, IOException {
        super(uRL, locale);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        return XMLResourceBundle.getBundle(string, locale, classLoader, null);
    }

    public static ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader, XMLResourceBundleFailureHandler xMLResourceBundleFailureHandler) throws MissingResourceException {
        return XMLResourceBundle.getBundle(string, locale, classLoader, xMLResourceBundleFailureHandler, factory);
    }

    protected DefaultHandler getDefaultHandler() {
        return new SAXHandler(this);
    }

    public String getString(String string, String string2) {
        try {
            return super.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    public int getInteger(String string) throws MissingResourceException, NumberFormatException {
        return Integer.parseInt(this.getString(string).trim());
    }

    public int getInteger(String string, int n) {
        try {
            return this.getInteger(string);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public boolean getBoolean(String string) throws MissingResourceException {
        String string2 = this.getString(string).trim().toLowerCase();
        return string2.equals("true") || string2.equals("yes") || string2.equals("on");
    }

    public boolean getBoolean(String string, boolean bl) {
        try {
            return this.getBoolean(string);
        }
        catch (MissingResourceException missingResourceException) {
            return bl;
        }
    }

    public void put(String string, String string2) {
        super.put(string, string2);
    }

    public String remove(String string) {
        return super.remove(string);
    }

    public void writeTo(Result result) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        this.writeTo(result, false);
    }

    public void writeTo(Result result, boolean bl) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        this.writeTo(result, null, bl);
    }

    public void writeTo(Result result, String string) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        this.writeTo(result, string, false);
    }

    public void writeTo(Result result, String string, boolean bl) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Object object;
        Node node = null;
        if (result instanceof DOMResult) {
            node = ((DOMResult)result).getNode();
        }
        if (node == null) {
            object = this.newDocumentBuilder();
            node = ((DocumentBuilder)object).newDocument();
        }
        object = null;
        object = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = object.createElement(PROPERTIES_TAG);
        node.appendChild(element);
        Enumeration enumeration = this.getKeys();
        Element element2 = null;
        String string2 = null;
        Object object2 = null;
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            object2 = this.getObject(string2);
            element2 = object.createElement(PROPERTY_TAG);
            element2.setAttribute(KEY_ATTRIBUTE, string2);
            element2.appendChild(object.createTextNode(object2.toString()));
            element.appendChild(element2);
        }
        Transformer transformer = this.newTransformer();
        if (string != null) {
            transformer.setOutputProperty("encoding", string);
        }
        if (bl) {
            transformer.setOutputProperty("indent", "yes");
        }
        transformer.transform(new DOMSource(element), result);
    }

    protected Transformer newTransformer() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
        return XMLResourceBundle.getTransformerFactory().newTransformer();
    }

    protected DocumentBuilder newDocumentBuilder() throws ParserConfigurationException, FactoryConfigurationError {
        return XMLResourceBundle.getDocumentBuilderFactory().newDocumentBuilder();
    }

    protected static TransformerFactory getTransformerFactory() throws TransformerFactoryConfigurationError {
        if (transformerFactory == null) {
            transformerFactory = TransformerFactory.newInstance();
        }
        return transformerFactory;
    }

    protected static DocumentBuilderFactory getDocumentBuilderFactory() throws FactoryConfigurationError {
        if (documentBuilderFactory == null) {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return documentBuilderFactory;
    }

    public static void main(String[] stringArray) throws Exception {
        XMLResourceBundle xMLResourceBundle = new XMLResourceBundle();
        xMLResourceBundle.put("path", "/usr/rsk/");
        xMLResourceBundle.put("width", "350");
        xMLResourceBundle.put("height", "200");
        File file = new File("properties.xml");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        System.out.println(xMLResourceBundle.toString());
    }

    protected static class SAXHandler
    extends DefaultHandler {
        public static final String EMPTY_STRING = "";
        protected XMLResourceBundle resourceBundle = null;
        protected String propertyKey = "";
        protected StringBuffer propertyValue = new StringBuffer();
        protected boolean propertyElementStarted = false;
        protected boolean propertiesElementStarted = false;

        public SAXHandler(XMLResourceBundle xMLResourceBundle) {
            this.resourceBundle = xMLResourceBundle;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (XMLResourceBundle.PROPERTIES_TAG.equals(string3)) {
                this.propertiesElementStarted = true;
            } else if (XMLResourceBundle.PROPERTY_TAG.equals(string3)) {
                if (!this.propertiesElementStarted) {
                    throw new SAXException(XMLResourceBundle.ROOT_MUST_BE_PROPERTIES);
                }
                this.propertyElementStarted = true;
                this.propertyKey = attributes.getValue(XMLResourceBundle.KEY_ATTRIBUTE);
                if (this.propertyKey == null || this.propertyKey.length() == 0) {
                    throw new SAXException(XMLResourceBundle.KEY_ATTRIBUTE_MISSING);
                }
                this.propertyValue.setLength(0);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (XMLResourceBundle.PROPERTIES_TAG.equals(string3)) {
                this.propertiesElementStarted = false;
            } else if (XMLResourceBundle.PROPERTY_TAG.equals(string3)) {
                this.propertyElementStarted = false;
                if (this.propertyKey != EMPTY_STRING) {
                    this.resourceBundle.put(this.propertyKey, this.propertyValue.toString());
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.propertyElementStarted && this.propertyKey != EMPTY_STRING) {
                this.propertyValue.append(cArray, n, n2);
            }
        }

        public void warning(SAXException sAXException) throws SAXException {
            throw sAXException;
        }

        public void error(SAXException sAXException) throws SAXException {
            throw sAXException;
        }

        public void fatalError(SAXException sAXException) throws SAXException {
            throw sAXException;
        }
    }

    protected static class XMLResourceBundleFactory
    implements AbstractXMLBasedResourceBundle.XMLBasedResourceBundleFactory {
        protected XMLResourceBundleFactory() {
        }

        public AbstractXMLBasedResourceBundle createXMLResourceBundle(URL uRL, Locale locale) throws SAXException, ParserConfigurationException, IOException {
            return new XMLResourceBundle(uRL, locale);
        }
    }
}

