/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessor;
import com.softwareag.tamino.db.api.accessor.TAdminException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TUri;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TTransactionParameters;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class TAbstractAccessor
implements TAccessor {
    private TSharedAccessorProperties sharedAccessorProperties = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TAbstractAccessor.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TAbstractAccessor.class);
    private long maximumRequestDuration;
    private String applicationName = "TAJ";
    protected int requestCounter = 0;
    protected boolean canBeCancelled = false;
    protected String SGUAI = null;
    protected List clientRequests = Collections.synchronizedList(new ArrayList());

    protected TAbstractAccessor() {
        this.sharedAccessorProperties = new TSharedAccessorProperties();
    }

    protected TAbstractAccessor(TAbstractAccessor tAbstractAccessor) {
        this.sharedAccessorProperties = tAbstractAccessor.sharedAccessorProperties;
    }

    protected TAbstractAccessor(TAccessLocation tAccessLocation, TInvocation tInvocation) {
        this.sharedAccessorProperties = new TSharedAccessorProperties(tAccessLocation, tInvocation);
    }

    public void invalidate() {
        this.sharedAccessorProperties.isValid = false;
    }

    public synchronized void setAccessLocation(TAccessLocation tAccessLocation) {
        this.sharedAccessorProperties.accessLocation = tAccessLocation;
    }

    public synchronized TAccessLocation getAccessLocation() {
        return (TAccessLocation)this.sharedAccessorProperties.accessLocation.clone();
    }

    protected synchronized TInvocation getInvocation() {
        return this.sharedAccessorProperties.invocation;
    }

    public synchronized void setInvocation(TInvocation tInvocation) {
        this.sharedAccessorProperties.invocation = tInvocation;
    }

    protected TUri getDatabaseUri() {
        return this.sharedAccessorProperties.invocation.getDatabaseUri();
    }

    protected synchronized String getAccessCollection() {
        return this.sharedAccessorProperties.accessLocation.getCollection();
    }

    public synchronized void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        this.sharedAccessorProperties.transactionParameters.setLockwaitMode(tLockwaitMode);
    }

    public synchronized TLockwaitMode getLockwaitMode() {
        return this.sharedAccessorProperties.transactionParameters.getLockwaitMode();
    }

    public synchronized void setLockMode(TLockMode tLockMode) {
        this.sharedAccessorProperties.transactionParameters.setLockMode(tLockMode);
    }

    public synchronized TLockMode getLockMode() {
        return this.sharedAccessorProperties.transactionParameters.getLockMode();
    }

    public void setMaximumRequestDuration(long l) {
        Precondition.check(l >= 0L, "Invalid maximum request duration");
        this.maximumRequestDuration = l;
    }

    public long getMaximumRequestDuration() {
        return this.maximumRequestDuration;
    }

    public TInputStream invoke(TCommandStatement tCommandStatement) throws TInvocationException {
        Precondition.check(this.sharedAccessorProperties.isValid, "Accessor has been invalidated. Use no longer possible!");
        this.sharedAccessorProperties.transactionParameters.writeTo(tCommandStatement);
        String string = null;
        if (this.getCanBeCancelled()) {
            string = this.getClientRequestId();
            tCommandStatement.addCommandParameter(TCommandParameter.CLIENTREQUESTID, new TCommandParameterValue(string));
            this.clientRequests.add(string);
        }
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        TInputStream tInputStream = this.sharedAccessorProperties.invocation.invoke(tCommandStatement);
        if (this.getCanBeCancelled()) {
            this.clientRequests.remove(string);
        }
        return tInputStream;
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, String string) throws TInvocationException {
        Precondition.check(this.sharedAccessorProperties.isValid, "Accessor has been invalidated. Use no longer possible!");
        this.sharedAccessorProperties.transactionParameters.writeTo(tCommandStatement);
        String string2 = null;
        if (this.getCanBeCancelled()) {
            string2 = this.getClientRequestId();
            tCommandStatement.addCommandParameter(TCommandParameter.CLIENTREQUESTID, new TCommandParameterValue(string2));
            this.clientRequests.add(string2);
        }
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        TInputStream tInputStream = this.sharedAccessorProperties.invocation.invoke(tCommandStatement, string);
        if (this.getCanBeCancelled()) {
            this.clientRequests.remove(string2);
        }
        return tInputStream;
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, String string, String string2, String string3) throws TInvocationException {
        Precondition.check(this.sharedAccessorProperties.isValid, "Accessor has been invalidated. Use no longer possible!");
        this.sharedAccessorProperties.transactionParameters.writeTo(tCommandStatement);
        String string4 = null;
        if (this.getCanBeCancelled()) {
            string4 = this.getClientRequestId();
            tCommandStatement.addCommandParameter(TCommandParameter.CLIENTREQUESTID, new TCommandParameterValue(string4));
            this.clientRequests.add(string4);
        }
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        TInputStream tInputStream = this.sharedAccessorProperties.invocation.invoke(tCommandStatement, string, string2, string3);
        if (this.getCanBeCancelled()) {
            this.clientRequests.remove(string4);
        }
        return tInputStream;
    }

    public void setApplicationName(String string) {
        this.applicationName = string;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    private String getClientRequestId() {
        StringBuffer stringBuffer = new StringBuffer(this.SGUAI);
        stringBuffer.append(this.getApplicationName());
        ++this.requestCounter;
        stringBuffer.append(this.requestCounter);
        return stringBuffer.toString();
    }

    public void cancelRequests() throws TAdminException {
        for (int i = 0; i < this.clientRequests.size(); ++i) {
            String string = (String)this.clientRequests.get(i);
            try {
                TCommandStatement tCommandStatement = new TCommandStatement(TCommand.ADMIN, new TCommandValue("ino:Accessor(\"cancelRequest\",  \"" + string + "\")"));
                TInputStream tInputStream = this.invoke(tCommandStatement);
                continue;
            }
            catch (TInvocationException tInvocationException) {
                throw new TAdminException(tInvocationException);
            }
        }
    }

    public void setCanBeCancelled(boolean bl) throws TAdminException {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.ADMIN, new TCommandValue("ino:Accessor(\"getId\")"));
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement);
            TStreamHeader tStreamHeader = tInputStream.getHeader();
            this.SGUAI = tStreamHeader.getValue("X-INO-clientRequestId");
            this.canBeCancelled = bl;
        }
        catch (TInvocationException tInvocationException) {
            throw new TAdminException(tInvocationException);
        }
    }

    public boolean getCanBeCancelled() {
        return this.canBeCancelled;
    }

    private static class TSharedAccessorProperties {
        private boolean isValid = true;
        private TAccessLocation accessLocation = null;
        private TInvocation invocation = null;
        private TTransactionParameters transactionParameters = new TTransactionParameters();

        private TSharedAccessorProperties() {
        }

        private TSharedAccessorProperties(TAccessLocation tAccessLocation, TInvocation tInvocation) {
            this();
            this.accessLocation = tAccessLocation;
            this.invocation = tInvocation;
        }
    }
}

