/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessFailureVerifier;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorMessages;
import com.softwareag.tamino.db.api.accessor.TAdminException;
import com.softwareag.tamino.db.api.accessor.TDefineException;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessorImpl;
import com.softwareag.tamino.db.api.accessor.TUndefineException;
import com.softwareag.tamino.db.api.accessor.TUndefineItem;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseHandle;

public abstract class TAbstractSchemaDefinitionAccessor
extends TAbstractAccessor {
    private TStreamAccessor streamAccessor = null;
    private TResponseBuilder responseBuilder = null;
    private TAccessFailureVerifier accessFailureVerifier = TAccessFailureVerifier.getInstance();
    private static final boolean PRE_CHECK = Precondition.isEnabled(TAbstractSchemaDefinitionAccessor.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TAbstractSchemaDefinitionAccessor.class);

    public TAbstractSchemaDefinitionAccessor(TStreamAccessor tStreamAccessor, TResponseBuilder tResponseBuilder) {
        super((TAbstractAccessor)((Object)tStreamAccessor));
        this.streamAccessor = tStreamAccessor;
        this.clientRequests = ((TStreamAccessorImpl)tStreamAccessor).clientRequests;
        this.responseBuilder = tResponseBuilder;
    }

    public TResponse define(TXMLObject tXMLObject) throws TDefineException {
        TResponseHandle tResponseHandle = null;
        String string = tXMLObject.getId();
        String string2 = tXMLObject.getDocname();
        try {
            tXMLObject.setId("");
            tXMLObject.setDocname("");
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.define(tXMLObject));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TDefineException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        tXMLObject.setId(string);
        tXMLObject.setDocname(string2);
        this.accessFailureVerifier.verifyDefineResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse undefine(String string, String string2) throws TUndefineException {
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.undefine(string, string2));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TUndefineException(TAccessorMessages.TAJACE0002, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyUndefineResponse(tResponseHandle);
        return tResponseHandle;
    }

    public TResponse undefine(TUndefineItem[] tUndefineItemArray) throws TUndefineException {
        TResponseHandle tResponseHandle = null;
        try {
            tResponseHandle = this.responseBuilder.buildForXML(this.streamAccessor.undefine(tUndefineItemArray));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TUndefineException(TAccessorMessages.TAJACE0002, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyUndefineResponse(tResponseHandle);
        return tResponseHandle;
    }

    public synchronized void setAccessLocation(TAccessLocation tAccessLocation) {
        Precondition.check(false, "Access location is fixed. Setting a new value is not possible");
    }

    protected final TStreamAccessor getStreamAccessor() {
        return this.streamAccessor;
    }

    protected final TResponseBuilder getResponseBuilder() {
        return this.responseBuilder;
    }

    protected final TAccessFailureVerifier getAccessFailureVerifier() {
        return this.accessFailureVerifier;
    }

    public void setCanBeCancelled(boolean bl) throws TAdminException {
        this.streamAccessor.setCanBeCancelled(bl);
    }

    public void cancelRequests() throws TAdminException {
        this.streamAccessor.cancelRequests();
    }

    public void setMaximumRequestDuration(long l) {
        Precondition.check(l >= 0L, "Invalid maximum request duration");
        this.streamAccessor.setMaximumRequestDuration(l);
    }
}

