/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.tamino.db.api.accessor.TDefineException;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TUndefineException;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.accessor.TXQueryException;
import com.softwareag.tamino.db.api.common.TAccessFailureException;
import com.softwareag.tamino.db.api.response.TResponseHandle;

public class TAccessFailureVerifier {
    private static TAccessFailureVerifier singleton = null;

    public static synchronized TAccessFailureVerifier getInstance() {
        if (singleton == null) {
            singleton = new TAccessFailureVerifier();
        }
        return singleton;
    }

    public void verifyInsertResponse(TResponseHandle tResponseHandle) throws TInsertException {
        TAccessFailureException tAccessFailureException = this.verify(tResponseHandle);
        if (tAccessFailureException != null) {
            throw new TInsertException(tAccessFailureException.getMessage(), (Exception)tAccessFailureException);
        }
    }

    public void verifyUpdateResponse(TResponseHandle tResponseHandle) throws TUpdateException {
        TAccessFailureException tAccessFailureException = this.verify(tResponseHandle);
        if (tAccessFailureException != null) {
            throw new TUpdateException(tAccessFailureException.getMessage(), (Exception)tAccessFailureException);
        }
    }

    public void verifyDeleteResponse(TResponseHandle tResponseHandle) throws TDeleteException {
        TAccessFailureException tAccessFailureException = this.verify(tResponseHandle);
        if (tAccessFailureException != null) {
            throw new TDeleteException(tAccessFailureException.getMessage(), (Exception)tAccessFailureException);
        }
    }

    public void verifyQueryResponse(TResponseHandle tResponseHandle) throws TQueryException {
        TAccessFailureException tAccessFailureException = this.verify(tResponseHandle);
        if (tAccessFailureException != null) {
            throw new TQueryException(tAccessFailureException.getMessage(), (Exception)tAccessFailureException);
        }
    }

    public void verifyXQueryResponse(TResponseHandle tResponseHandle) throws TXQueryException {
        TAccessFailureException tAccessFailureException = this.verify(tResponseHandle);
        if (tAccessFailureException != null) {
            throw new TXQueryException(tAccessFailureException.getMessage(), (Exception)tAccessFailureException);
        }
    }

    public void verifyDefineResponse(TResponseHandle tResponseHandle) throws TDefineException {
        TAccessFailureException tAccessFailureException = this.verify(tResponseHandle);
        if (tAccessFailureException != null) {
            throw new TDefineException(tAccessFailureException.getMessage(), (Exception)tAccessFailureException);
        }
    }

    public void verifyUndefineResponse(TResponseHandle tResponseHandle) throws TUndefineException {
        TAccessFailureException tAccessFailureException = this.verify(tResponseHandle);
        if (tAccessFailureException != null) {
            throw new TUndefineException(tAccessFailureException.getMessage(), (Exception)tAccessFailureException);
        }
    }

    protected TAccessFailureException verify(TResponseHandle tResponseHandle) {
        TAccessFailureException tAccessFailureException = null;
        String string = tResponseHandle.getReturnValue();
        if (!string.equals("0") && !string.equals("")) {
            tAccessFailureException = this.newAccessFailureException(tResponseHandle);
        }
        return tAccessFailureException;
    }

    private TAccessFailureException newAccessFailureException(TResponseHandle tResponseHandle) {
        String string = tResponseHandle.getReturnValue();
        String string2 = tResponseHandle.getMessageCode();
        String string3 = tResponseHandle.getMessageText();
        String string4 = tResponseHandle.getMessageLine();
        return new TAccessFailureException(string, string2, string3, string4);
    }
}

