/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessorException;
import com.softwareag.tamino.db.api.accessor.TAdminException;
import com.softwareag.tamino.db.api.accessor.TAdministrationAccessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessorImpl;
import com.softwareag.tamino.db.api.accessor.TSystemAccessorImpl;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.response.TResponseBuilder;

public class TAdministrationAccessorImpl
extends TAbstractAccessor
implements TAdministrationAccessor {
    private TStreamAccessor streamAccessor = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(TSystemAccessorImpl.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TSystemAccessorImpl.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.5 $");

    public TAdministrationAccessorImpl(TStreamAccessor tStreamAccessor, TResponseBuilder tResponseBuilder) {
        super((TAbstractAccessor)((Object)tStreamAccessor));
        this.streamAccessor = tStreamAccessor;
        this.clientRequests = ((TStreamAccessorImpl)tStreamAccessor).clientRequests;
    }

    public TInputStream execute(String string) throws TAccessorException {
        return this.streamAccessor.admin(string);
    }

    public void setCanBeCancelled(boolean bl) throws TAdminException {
        this.streamAccessor.setCanBeCancelled(bl);
    }

    public void cancelRequests() throws TAdminException {
        try {
            TConnection tConnection = TConnectionFactory.getInstance().newConnection(this.getDatabaseUri().getAsString());
            TStreamAccessorImpl tStreamAccessorImpl = (TStreamAccessorImpl)tConnection.newStreamAccessor(this.getAccessLocation());
            tStreamAccessorImpl.clientRequests = this.clientRequests;
            tStreamAccessorImpl.cancelRequests();
        }
        catch (TServerNotAvailableException tServerNotAvailableException) {
            throw new TAdminException(tServerNotAvailableException);
        }
    }

    public void setApplicationName(String string) {
        this.streamAccessor.setApplicationName(string);
    }

    public String getApplicationName() {
        return this.streamAccessor.getApplicationName();
    }
}

