/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessFailureVerifier;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorMessages;
import com.softwareag.tamino.db.api.accessor.TAdminException;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TOutputMethod;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryBuilder;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TRetrieveException;
import com.softwareag.tamino.db.api.accessor.TSystemAccessorImpl;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.accessor.TXQuery;
import com.softwareag.tamino.db.api.accessor.TXQueryException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObject;
import com.softwareag.tamino.db.api.response.THeaderEnlister;
import com.softwareag.tamino.db.api.response.TObjectContentItem;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseHandle;
import java.io.IOException;

public class TNonXMLObjectAccessorImpl
extends TAbstractAccessor
implements TNonXMLObjectAccessor {
    private TResponseBuilder responseBuilder = null;
    private TAccessFailureVerifier accessFailureVerifier = TAccessFailureVerifier.getInstance();
    private THeaderEnlister headerEnlister = THeaderEnlister.getInstance();
    private static final boolean PRE_CHECK = Precondition.isEnabled(TNonXMLObjectAccessorImpl.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TNonXMLObjectAccessorImpl.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.33 $");

    public TNonXMLObjectAccessorImpl(TAccessLocation tAccessLocation, TInvocation tInvocation, TResponseBuilder tResponseBuilder) {
        super(tAccessLocation, tInvocation);
        this.responseBuilder = tResponseBuilder;
    }

    public synchronized TResponse insert(TNonXMLObject tNonXMLObject) throws TInsertException {
        Precondition.check(tNonXMLObject != null, "TNonXMLObject == null, please pass a valid instance.");
        Precondition.check(tNonXMLObject.getCollection().equals("") || tNonXMLObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the xmlObject's collection " + tNonXMLObject.getCollection() + "!");
        Precondition.check(!tNonXMLObject.getDoctype().equals(""), "TNonXMLObject does not contain doctype information!");
        Precondition.check(!tNonXMLObject.getContentType().equals(""), "TNonXMLObject does not contain content type information!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Insert");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.PROCESS, new TCommandValue(tNonXMLObject));
        TResponseHandle tResponseHandle = null;
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection(), tNonXMLObject.getDoctype(), tNonXMLObject.getDocname());
            tResponseHandle = this.responseBuilder.buildForNonXML(tInputStream);
            TObjectContentItem tObjectContentItem = (TObjectContentItem)tResponseHandle.getInfoContent().getItem(0, TObjectContentItem.SPECIFIER);
            if (tObjectContentItem != null) {
                tNonXMLObject.setId(tObjectContentItem.getId());
                tNonXMLObject.setCollection(tObjectContentItem.getCollection());
                tNonXMLObject.setDoctype(tObjectContentItem.getDoctype());
                this.headerEnlister.enlistLastModified(tResponseHandle, (TDataObject)tNonXMLObject);
            }
        }
        catch (TInvocationException tInvocationException) {
            throw new TInsertException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TInsertException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyInsertResponse(tResponseHandle);
        return tResponseHandle;
    }

    public synchronized TResponse update(TNonXMLObject tNonXMLObject) throws TUpdateException {
        Precondition.check(tNonXMLObject != null, "TNonXMLObject == null, please pass a valid instance.");
        Precondition.check(tNonXMLObject.getCollection().equals("") || tNonXMLObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the xmlObject's collection " + tNonXMLObject.getCollection() + "!");
        Precondition.check(!tNonXMLObject.getDoctype().equals(""), "TNonXMLObject does not contain doctype information!");
        Precondition.check(tNonXMLObject.hasId() || tNonXMLObject.hasDocname(), "Either id or docname has to be given on TNonXMLObject instance!");
        Precondition.check(!tNonXMLObject.getContentType().equals(""), "TNonXMLObject does not contain content type information!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Update");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.PROCESS, new TCommandValue(tNonXMLObject));
        TResponseHandle tResponseHandle = null;
        try {
            String string = tNonXMLObject.getDocname();
            string = !string.equals("") ? string : "@" + tNonXMLObject.getId();
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection(), tNonXMLObject.getDoctype(), string);
            tResponseHandle = this.responseBuilder.buildForNonXML(tInputStream);
            TObjectContentItem tObjectContentItem = (TObjectContentItem)tResponseHandle.getInfoContent().getItem(0, TObjectContentItem.SPECIFIER);
            if (tObjectContentItem != null) {
                tNonXMLObject.setId(tObjectContentItem.getId());
                tNonXMLObject.setCollection(tObjectContentItem.getCollection());
                tNonXMLObject.setDoctype(tObjectContentItem.getDoctype());
                this.headerEnlister.enlistLastModified(tResponseHandle, (TDataObject)tNonXMLObject);
            }
        }
        catch (TInvocationException tInvocationException) {
            throw new TUpdateException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TUpdateException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyUpdateResponse(tResponseHandle);
        return tResponseHandle;
    }

    public synchronized TResponse delete(TNonXMLObject tNonXMLObject) throws TDeleteException {
        Precondition.check(tNonXMLObject != null, "TNonXMLObject == null, please pass a valid instance.");
        Precondition.check(tNonXMLObject.getCollection().equals("") || tNonXMLObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the xmlObject's collection " + tNonXMLObject.getCollection() + "!");
        Precondition.check(!tNonXMLObject.getDoctype().equals(""), "TNonXMLObject does not contain doctype information!");
        Precondition.check(tNonXMLObject.hasDocname() || tNonXMLObject.hasId(), "TNonXMLObject does neither contain docname nor id information!");
        TQuery tQuery = null;
        tQuery = tNonXMLObject.hasId() ? TQueryBuilder.getInstance().buildFromId(tNonXMLObject.getDoctype(), tNonXMLObject.getId()) : TQueryBuilder.getInstance().buildFromDocname(tNonXMLObject.getDoctype(), tNonXMLObject.getDocname());
        TResponseHandle tResponseHandle = (TResponseHandle)this.delete(tQuery);
        this.headerEnlister.enlistLastModified(tResponseHandle, (TDataObject)tNonXMLObject);
        return tResponseHandle;
    }

    public synchronized TResponse delete(TQuery tQuery) throws TDeleteException {
        Precondition.check(tQuery != null, "XPath statement is not given!");
        Precondition.check(!tQuery.getExpression().equals(""), "XPath statement is not given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Delete By Query");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DELETE, new TCommandValue(tQuery.getExpression()));
        TResponseHandle tResponseHandle = null;
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection());
            tResponseHandle = this.responseBuilder.buildForNonXML(tInputStream);
        }
        catch (TInvocationException tInvocationException) {
            throw new TDeleteException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TDeleteException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyDeleteResponse(tResponseHandle);
        return tResponseHandle;
    }

    public synchronized TResponse query(TQuery tQuery) throws TQueryException {
        Precondition.check(tQuery != null, "XPath statement is not given!");
        Precondition.check(!tQuery.getExpression().equals(""), "XPath statement is not given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Query");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        TResponseHandle tResponseHandle = null;
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection());
            tResponseHandle = this.responseBuilder.buildForNonXML(tInputStream);
        }
        catch (TInvocationException tInvocationException) {
            throw new TQueryException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TQueryException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyQueryResponse(tResponseHandle);
        return tResponseHandle;
    }

    public synchronized TResponse xquery(TXQuery tXQuery) throws TXQueryException {
        Precondition.check(tXQuery != null, "XPath statement is not given!");
        Precondition.check(!tXQuery.getExpression().equals(""), "XPath statement is not given!");
        Precondition.check(tXQuery.getOutputMethod() != TOutputMethod.TEXT && tXQuery.getOutputMethod() != TOutputMethod.XML, "Invalid serialization method is used to retrieve nonXML document!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Query");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.XQUERY, new TCommandValue(tXQuery.getExpression()));
        TResponseHandle tResponseHandle = null;
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection());
            tResponseHandle = this.responseBuilder.buildForNonXML(tInputStream);
        }
        catch (TInvocationException tInvocationException) {
            throw new TXQueryException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TXQueryException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyXQueryResponse(tResponseHandle);
        return tResponseHandle;
    }

    public synchronized TNonXMLObject retrieve(TNonXMLObject tNonXMLObject) throws TRetrieveException {
        Precondition.check(tNonXMLObject != null, "TNonXMLObject == null, please pass a valid instance.");
        Precondition.check(!tNonXMLObject.getDoctype().equals(""), "No doctype information given!");
        Precondition.check(tNonXMLObject.hasId() || tNonXMLObject.hasDocname(), "Either no id or docname is given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("retrieve");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.RETRIEVE, new TCommandValue("?"));
        String string = tNonXMLObject.getDocname();
        string = !string.equals("") ? string : "@" + tNonXMLObject.getId();
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection(), tNonXMLObject.getDoctype(), string);
            tNonXMLObject.readFrom(tInputStream);
            this.headerEnlister.enlistAll(tInputStream, (TDataObject)tNonXMLObject);
            return tNonXMLObject;
        }
        catch (TInvocationException tInvocationException) {
            throw new TRetrieveException(TAccessorMessages.TAJACE0003, (Exception)tInvocationException);
        }
        catch (TStreamReadException tStreamReadException) {
            throw new TRetrieveException(TAccessorMessages.TAJACE0003, (Exception)tStreamReadException);
        }
    }

    public TStreamHeader retrieveHeader(TNonXMLObject tNonXMLObject) throws TRetrieveException {
        TStreamHeader tStreamHeader;
        block4: {
            Precondition.check(tNonXMLObject != null, "TNonXMLObject == null, please pass a valid instance.");
            Precondition.check(!tNonXMLObject.getDoctype().equals(""), "No doctype information given!");
            Precondition.check(tNonXMLObject.hasId() || tNonXMLObject.hasDocname(), "Either no id or docname is given!");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("retrieveHeader");
            }
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.RETRIEVE_HEAD, new TCommandValue("?"));
            String string = tNonXMLObject.getDocname();
            string = !string.equals("") ? string : "@" + tNonXMLObject.getId();
            tStreamHeader = null;
            try {
                TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection(), tNonXMLObject.getDoctype(), string);
                tStreamHeader = tInputStream.getHeader();
                tInputStream.close();
            }
            catch (TInvocationException tInvocationException) {
                throw new TRetrieveException(TAccessorMessages.TAJACE0003, (Exception)tInvocationException);
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.warning("Closing of the retrieveHeader input stream failed: " + iOException);
            }
        }
        return tStreamHeader;
    }

    public void cancelRequests() throws TAdminException {
        try {
            TConnection tConnection = TConnectionFactory.getInstance().newConnection(this.getDatabaseUri().getAsString());
            TSystemAccessorImpl tSystemAccessorImpl = (TSystemAccessorImpl)tConnection.newSystemAccessor();
            tSystemAccessorImpl.clientRequests = this.clientRequests;
            tSystemAccessorImpl.cancelRequests();
        }
        catch (TServerNotAvailableException tServerNotAvailableException) {
            throw new TAdminException(tServerNotAvailableException);
        }
    }
}

