/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorMessages;
import com.softwareag.tamino.db.api.accessor.TAdminException;
import com.softwareag.tamino.db.api.accessor.TCursorException;
import com.softwareag.tamino.db.api.accessor.TDefineException;
import com.softwareag.tamino.db.api.accessor.TDefineMode;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TPreparedXQuery;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TRetrieveException;
import com.softwareag.tamino.db.api.accessor.TScroll;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessorImpl;
import com.softwareag.tamino.db.api.accessor.TUndefineException;
import com.softwareag.tamino.db.api.accessor.TUndefineItem;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.accessor.TXQuery;
import com.softwareag.tamino.db.api.accessor.TXQueryException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamHeader;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class TStreamAccessorImpl
extends TAbstractAccessor
implements TStreamAccessor {
    private TScroll scrollType = TScroll.NO;
    private TPreference preference = TPreference.getInstance();
    private static final boolean PRE_CHECK = Precondition.isEnabled(TStreamAccessorImpl.class);
    private static final boolean POST_CHECK = Postcondition.isEnabled(TStreamAccessorImpl.class);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.45 $");

    public TStreamAccessorImpl(TAccessLocation tAccessLocation, TInvocation tInvocation) {
        super(tAccessLocation, tInvocation);
    }

    public TStreamAccessorImpl(TAbstractAccessor tAbstractAccessor) {
        super(tAbstractAccessor);
    }

    public synchronized TInputStream insert(TDataObject tDataObject) throws TInsertException {
        Precondition.check(tDataObject != null, "No dataObject given!");
        Precondition.check(tDataObject.getCollection().equals("") || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("insert");
        }
        String string = tDataObject.getId();
        tDataObject.setId(null);
        String string2 = tDataObject.getDocname();
        tDataObject.setDocname(null);
        String string3 = tDataObject.getDoctype();
        try {
            TInputStream tInputStream = null;
            tInputStream = string2.length() > 0 ? this.process(tDataObject, string3, string2) : this.process(tDataObject, null, null);
            tDataObject.setCollection(this.getAccessCollection());
            TInputStream tInputStream2 = tInputStream;
            return tInputStream2;
        }
        catch (TInvocationException tInvocationException) {
            throw new TInsertException(tInvocationException);
        }
        finally {
            tDataObject.setId(string);
            tDataObject.setDocname(string2);
        }
    }

    public synchronized TInputStream update(TDataObject tDataObject) throws TUpdateException {
        Precondition.check(tDataObject != null, "No dataObject given!");
        Precondition.check(tDataObject.getCollection().equals("") || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        Precondition.check(tDataObject.hasId() || tDataObject.hasDocname(), "Update not possible. TXMLObject instance does not contain an ino:id!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("update");
        }
        String string = tDataObject.getId();
        String string2 = tDataObject.getDocname();
        tDataObject.setDocname(null);
        String string3 = tDataObject.getDoctype();
        try {
            TInputStream tInputStream = null;
            tInputStream = string.length() == 0 && string2.length() > 0 ? this.process(tDataObject, string3, string2) : this.process(tDataObject, null, null);
            tDataObject.setCollection(this.getAccessCollection());
            TInputStream tInputStream2 = tInputStream;
            return tInputStream2;
        }
        catch (TInvocationException tInvocationException) {
            throw new TUpdateException(tInvocationException);
        }
        finally {
            tDataObject.setId(string);
            tDataObject.setDocname(string2);
        }
    }

    public synchronized TInputStream delete(TDataObject tDataObject) throws TDeleteException {
        Precondition.check(tDataObject != null, "data object must be not null");
        Precondition.check(tDataObject.hasDoctype(), "Delete not possible. TXMLObject instance does not contain doctype information.");
        Precondition.check(!tDataObject.hasCollection() || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        Precondition.check(tDataObject.hasId() || tDataObject.hasDocname(), "Delete not possible. TXMLObject instance does not have an ino:id.");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("delete");
        }
        String string = null;
        string = tDataObject.hasId() ? tDataObject.getDoctype() + "[@" + TInoNamespace.ID + "=\"" + tDataObject.getId() + "\"]" : tDataObject.getDoctype() + "[@" + TInoNamespace.DOCNAME + "=\"" + tDataObject.getDocname() + "\"]";
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DELETE, new TCommandValue(string));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TDeleteException(tInvocationException);
        }
    }

    public synchronized TInputStream delete(TQuery tQuery) throws TDeleteException {
        Precondition.check(tQuery != null && !tQuery.getExpression().equals(""), "No query given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("delete");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DELETE, new TCommandValue(tQuery.getExpression()));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TDeleteException(tInvocationException);
        }
    }

    public synchronized TInputStream query(TQuery tQuery) throws TQueryException {
        Precondition.check(tQuery != null && tQuery.getExpression().length() > 0, "No query given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("query");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        if (tQuery.getQuerySearchMode() != null) {
            tCommandStatement.addCommandParameter(TCommandParameter.QUERYSEARCHMODE, new TCommandParameterValue(tQuery.getQuerySearchMode().toString()));
        }
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TQueryException(tInvocationException.getRootTCause().getMessage(), (Exception)tInvocationException);
        }
    }

    public synchronized TInputStream retrieve(TDataObject tDataObject) throws TRetrieveException {
        String string;
        Precondition.check(!tDataObject.getDoctype().equals(""), "No doctype information given!");
        Precondition.check(!tDataObject.getId().equals("") || !tDataObject.getDocname().equals(""), "Either no id or docname is given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("retrieve");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.RETRIEVE, new TCommandValue("?"));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        string = !(string = tDataObject.getDocname()).equals("") ? string : "@" + tDataObject.getId();
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), tDataObject.getDoctype(), string);
        }
        catch (TInvocationException tInvocationException) {
            throw new TRetrieveException(TAccessorMessages.TAJACE0003, (Exception)tInvocationException);
        }
    }

    public synchronized TStreamHeader retrieveHeader(TDataObject tDataObject) throws TRetrieveException {
        TStreamHeader tStreamHeader;
        block4: {
            Precondition.check(!tDataObject.getDoctype().equals(""), "No doctype information given!");
            Precondition.check(!tDataObject.getId().equals("") || !tDataObject.getDocname().equals(""), "Either no id or docname is given!");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("retrieveHeader");
            }
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.RETRIEVE_HEAD, new TCommandValue("?"));
            String string = tDataObject.getDocname();
            string = !string.equals("") ? string : "@" + tDataObject.getId();
            tStreamHeader = null;
            try {
                TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection(), tDataObject.getDoctype(), string);
                tStreamHeader = tInputStream.getHeader();
                tInputStream.close();
            }
            catch (TInvocationException tInvocationException) {
                throw new TRetrieveException(TAccessorMessages.TAJACE0003, (Exception)tInvocationException);
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.warning("Closing of the retrieveHeader input stream failed: " + iOException);
            }
        }
        return tStreamHeader;
    }

    public synchronized TInputStream define(TDataObject tDataObject) throws TDefineException {
        return this.define(tDataObject, new TDefineMode(false, false));
    }

    public synchronized TInputStream define(TDataObject tDataObject, boolean bl) throws TDefineException {
        return this.define(tDataObject, new TDefineMode(bl, false));
    }

    public synchronized TInputStream define(TDataObject tDataObject, TDefineMode tDefineMode) throws TDefineException {
        Precondition.check(tDataObject != null, "No dataObject given!");
        Precondition.check(tDefineMode != null, "No defineMode given!");
        Precondition.check(tDataObject.getCollection().equals("") || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("define");
        }
        String string = tDataObject.getId();
        tDataObject.setId(null);
        String string2 = tDataObject.getDocname();
        tDataObject.setDocname(null);
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DEFINE, new TCommandValue(tDataObject));
        StringBuffer stringBuffer = new StringBuffer();
        if (tDefineMode.isTest()) {
            stringBuffer.append(TCommandParameterValue.TEST);
        }
        if (tDefineMode.isValidate()) {
            stringBuffer.append(",");
            stringBuffer.append(TCommandParameterValue.VALIDATE);
        }
        if (tDefineMode.getValue() != null) {
            stringBuffer.append(",");
            stringBuffer.append(tDefineMode.getValue());
        }
        if (stringBuffer.length() > 0) {
            tCommandStatement.addCommandParameter(TCommandParameter.MODE, new TCommandParameterValue(stringBuffer.toString()));
        }
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement);
            return tInputStream;
        }
        catch (TInvocationException tInvocationException) {
            throw new TDefineException(tInvocationException);
        }
        finally {
            tDataObject.setId(string);
            tDataObject.setDocname(string2);
        }
    }

    public synchronized TInputStream define(TDataObject[] tDataObjectArray) throws TDefineException {
        return this.define(tDataObjectArray, new TDefineMode(false, false));
    }

    public synchronized TInputStream define(TDataObject[] tDataObjectArray, TDefineMode tDefineMode) throws TDefineException {
        int n;
        Precondition.check(tDataObjectArray != null, "No dataObject given!");
        Precondition.check(tDefineMode != null, "No defineMode given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("define");
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 1; n < tDataObjectArray.length; ++n) {
            stringBuffer.append("$s" + n);
            if (n == tDataObjectArray.length) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("$s" + n);
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DEFINE, new TCommandValue(stringBuffer.toString()));
        for (n = 0; n < tDataObjectArray.length; ++n) {
            tCommandStatement.addCommand(TCommand.newCommand("$s" + (n + 1)), new TCommandValue(tDataObjectArray[n]));
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        if (tDefineMode.isTest()) {
            stringBuffer2.append(TCommandParameterValue.TEST);
        }
        if (tDefineMode.isValidate()) {
            stringBuffer2.append(",");
            stringBuffer2.append(TCommandParameterValue.VALIDATE);
        }
        if (tDefineMode.getValue() != null) {
            stringBuffer2.append(",");
            stringBuffer2.append(tDefineMode.getValue());
        }
        if (stringBuffer2.length() > 0) {
            tCommandStatement.addCommandParameter(TCommandParameter.MODE, new TCommandParameterValue(stringBuffer2.toString()));
        }
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement);
            return tInputStream;
        }
        catch (TInvocationException tInvocationException) {
            throw new TDefineException(tInvocationException);
        }
    }

    public synchronized TInputStream undefine(String string, String string2) throws TUndefineException {
        Precondition.check(string != null && !string.equals(""), "No collection information given!");
        String string3 = string;
        if (string2 != null && !string2.equals("")) {
            string3 = string3 + "/" + string2;
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.UNDEFINE, new TCommandValue(string3));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        try {
            return this.invoke(tCommandStatement);
        }
        catch (TInvocationException tInvocationException) {
            throw new TUndefineException(tInvocationException);
        }
    }

    public TInputStream undefine(TUndefineItem[] tUndefineItemArray) throws TUndefineException {
        Precondition.check(tUndefineItemArray != null, "No Item to undefine!");
        Precondition.check(tUndefineItemArray.length != 0, "No Item to undefine!");
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < tUndefineItemArray.length; ++i) {
                stringBuffer.append(tUndefineItemArray[i].toString());
                if (i == tUndefineItemArray.length - 1) continue;
                stringBuffer.append(",");
            }
            TCommandStatement tCommandStatement = new TCommandStatement(TCommand.UNDEFINE, new TCommandValue(stringBuffer.toString()));
            if (this.getMaximumRequestDuration() != 0L) {
                tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
            }
            return this.invoke(tCommandStatement);
        }
        catch (TInvocationException tInvocationException) {
            throw new TUndefineException(tInvocationException);
        }
        catch (Exception exception) {
            throw new TUndefineException("UndefineItem is not specified properly");
        }
    }

    public synchronized TInputStream openCursor(TQuery tQuery) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Open cursor is not supported here. Change to local transaction mode!");
        Precondition.check(tQuery != null && !tQuery.getExpression().equals(""), "No query given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("openCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.OPEN);
        tCommandStatement.addCommand(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        if (this.getScrollType() == TScroll.YES) {
            tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_YES);
        } else {
            tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_NO);
        }
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        if (tQuery.getQuerySearchMode() != null) {
            tCommandStatement.addCommandParameter(TCommandParameter.QUERYSEARCHMODE, new TCommandParameterValue(tQuery.getQuerySearchMode().toString()));
        }
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream openCursor(TXQuery tXQuery) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Open cursor is not supported here. Change to local transaction mode!");
        Precondition.check(tXQuery != null && !tXQuery.getExpression().equals(""), "No xquery given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("openCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.OPEN);
        tCommandStatement.addCommand(TCommand.XQUERY, new TCommandValue(tXQuery.getExpression()));
        if (this.getScrollType() == TScroll.YES) {
            tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_YES);
        } else {
            tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_NO);
        }
        tCommandStatement.addCommandParameter(TCommandParameter.SENSITIVE, new TCommandParameterValue(tXQuery.getSensitive().toString()));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        if (tXQuery.extVarialbles != null && !tXQuery.extVarialbles.isEmpty()) {
            Set set = tXQuery.extVarialbles.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                String string2 = tXQuery.extVarialbles.get(string).toString();
                tCommandStatement.addCommand(TCommand.newCommand("$" + string), new TCommandValue(string2));
            }
        }
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream openCursor(TPreparedXQuery tPreparedXQuery) throws TCursorException {
        Object object;
        String string = tPreparedXQuery.getHandle();
        try {
            if (string == null || string.equals("")) {
                object = this.prepare(tPreparedXQuery);
                string = this.getPreparedHandle((TInputStream)object);
                tPreparedXQuery.setHandle(string);
                ((TInputStream)object).close();
            }
        }
        catch (TXQueryException tXQueryException) {
            throw new TCursorException(tXQueryException);
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Closing response inputStream failed with IOException: " + iOException);
            }
            throw new TCursorException("Response inputStream failed with IOException");
        }
        Precondition.check(this.getInvocation().supports(TCommand.PREPARE), "Prepared XQuery execution is not supported here. Change to local transaction mode!");
        Precondition.check(string != null && string.length() > 0, "No prepare handle given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("exuting prepared xquery");
        }
        object = new TCommandStatement(TCommand.EXECUTE, TCommandValue.PREPARED_XQUERY);
        ((TCommandStatement)object).addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        if (tPreparedXQuery.extVarialbles != null && !tPreparedXQuery.extVarialbles.isEmpty()) {
            Set set = tPreparedXQuery.extVarialbles.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                String string3 = tPreparedXQuery.extVarialbles.get(string2).toString();
                ((TCommandStatement)object).addCommand(TCommand.newCommand("$" + string2), new TCommandValue(string3));
            }
        }
        ((TCommandStatement)object).addCommand(TCommand.CURSOR, TCommandValue.OPEN);
        if (this.getScrollType() == TScroll.YES) {
            ((TCommandStatement)object).addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_YES);
        } else {
            ((TCommandStatement)object).addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_NO);
        }
        ((TCommandStatement)object).addCommandParameter(TCommandParameter.SENSITIVE, new TCommandParameterValue(tPreparedXQuery.getSensitive().toString()));
        if (this.getMaximumRequestDuration() != 0L) {
            ((TCommandStatement)object).addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        try {
            return this.invoke((TCommandStatement)object, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream openCursor(TQuery tQuery, int n, int n2) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Open cursor is not supported here. Change to local transaction mode!");
        Precondition.check(tQuery != null && !tQuery.getExpression().equals(""), "No query given!");
        Precondition.check(n >= 1, "Cursor position need to be equal or greater than 1!");
        Precondition.check(n2 > 0, "Fetch quantity needs to be greater than 0!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("openCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.OPEN);
        tCommandStatement.addCommand(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        if (tQuery.getQuerySearchMode() != null) {
            tCommandStatement.addCommandParameter(TCommandParameter.QUERYSEARCHMODE, new TCommandParameterValue(tQuery.getQuerySearchMode().toString()));
        }
        if (this.getScrollType() == TScroll.YES) {
            tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_YES);
        } else {
            tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_NO);
        }
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        tCommandStatement.addCommandParameter(TCommandParameter.COUNT, TCommandParameterValue.CHEAP);
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream openCursor(TXQuery tXQuery, int n, int n2) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Open cursor is not supported here. Change to local transaction mode!");
        Precondition.check(tXQuery != null && !tXQuery.getExpression().equals(""), "XQuery statement needs to be given!");
        Precondition.check(n >= 1, "Cursor position need to be equal or greater than 1!");
        Precondition.check(n2 > 0, "Fetch quantity needs to be greater than 0!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("openCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.OPEN);
        tCommandStatement.addCommand(TCommand.XQUERY, new TCommandValue(tXQuery.getExpression()));
        if (this.getScrollType() == TScroll.YES) {
            tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_YES);
        } else {
            tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_NO);
        }
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        tCommandStatement.addCommandParameter(TCommandParameter.COUNT, TCommandParameterValue.CHEAP);
        tCommandStatement.addCommandParameter(TCommandParameter.SENSITIVE, new TCommandParameterValue(tXQuery.getSensitive().toString()));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        if (tXQuery.extVarialbles != null && !tXQuery.extVarialbles.isEmpty()) {
            Set set = tXQuery.extVarialbles.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                String string2 = tXQuery.extVarialbles.get(string).toString();
                tCommandStatement.addCommand(TCommand.newCommand("$" + string), new TCommandValue(string2));
            }
        }
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream openCursor(TPreparedXQuery tPreparedXQuery, int n, int n2) throws TCursorException {
        Object object;
        String string = tPreparedXQuery.getHandle();
        try {
            if (string == null || string.equals("")) {
                object = this.prepare(tPreparedXQuery);
                string = this.getPreparedHandle((TInputStream)object);
                tPreparedXQuery.setHandle(string);
                ((TInputStream)object).close();
            }
        }
        catch (TXQueryException tXQueryException) {
            throw new TCursorException(tXQueryException);
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Closing response inputStream failed with IOException: " + iOException);
            }
            throw new TCursorException("Response inputStream failed with IOException");
        }
        Precondition.check(this.getInvocation().supports(TCommand.PREPARE), "Prepared XQuery execution is not supported here. Change to local transaction mode!");
        Precondition.check(string != null && string.length() > 0, "No cursor hanlde given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("exuting prepared xquery");
        }
        object = new TCommandStatement(TCommand.EXECUTE, TCommandValue.PREPARED_XQUERY);
        ((TCommandStatement)object).addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        if (tPreparedXQuery.extVarialbles != null && !tPreparedXQuery.extVarialbles.isEmpty()) {
            Set set = tPreparedXQuery.extVarialbles.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                String string3 = tPreparedXQuery.extVarialbles.get(string2).toString();
                ((TCommandStatement)object).addCommand(TCommand.newCommand("$" + string2), new TCommandValue(string3));
            }
        }
        ((TCommandStatement)object).addCommand(TCommand.CURSOR, TCommandValue.OPEN);
        ((TCommandStatement)object).addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        ((TCommandStatement)object).addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        ((TCommandStatement)object).addCommandParameter(TCommandParameter.COUNT, TCommandParameterValue.CHEAP);
        if (this.getScrollType() == TScroll.YES) {
            ((TCommandStatement)object).addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_YES);
        } else {
            ((TCommandStatement)object).addCommandParameter(TCommandParameter.SCROLL, TCommandParameterValue.SCROLL_NO);
        }
        ((TCommandStatement)object).addCommandParameter(TCommandParameter.SENSITIVE, new TCommandParameterValue(tPreparedXQuery.getSensitive().toString()));
        if (this.getMaximumRequestDuration() != 0L) {
            ((TCommandStatement)object).addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        try {
            return this.invoke((TCommandStatement)object, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream fetchCursor(String string, int n, int n2) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Fetch cursor is not supported here. Change to local transaction mode and open cursor first!");
        Precondition.check(string != null, "No cursorHandle given!");
        Precondition.check(n >= 1, "Cursor position need to be equal or greater than 1!");
        Precondition.check(n2 > 0, "Fetch quantity needs to be greater than 0!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("fetchCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.FETCH);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream closeCursor(String string) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Close cursor is not supported here. Change to local transaction mode and open cursor first!");
        Precondition.check(string != null, "No cursor hanlde given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("closeCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.CLOSE);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream xquery(TXQuery tXQuery) throws TXQueryException {
        if (tXQuery instanceof TPreparedXQuery) {
            return this.execute((TPreparedXQuery)tXQuery);
        }
        Precondition.check(tXQuery != null && tXQuery.getExpression().length() > 0, "No xquery expression given.");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("xquery");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.XQUERY, new TCommandValue(tXQuery.getExpression()));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        if (tXQuery.extVarialbles != null && !tXQuery.extVarialbles.isEmpty()) {
            Set set = tXQuery.extVarialbles.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                String string2 = tXQuery.extVarialbles.get(string).toString();
                tCommandStatement.addCommand(TCommand.newCommand("$" + string), new TCommandValue(string2));
            }
        }
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TXQueryException(tInvocationException.getRootTCause().getMessage(), (Exception)tInvocationException);
        }
    }

    public synchronized TInputStream prepare(TPreparedXQuery tPreparedXQuery) throws TXQueryException {
        Precondition.check(this.getInvocation().supports(TCommand.PREPARE), "Prepare is not supported here. Change to local transaction mode!");
        Precondition.check(tPreparedXQuery != null && tPreparedXQuery.getExpression().length() > 0, "No xquery expression given.");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("prepared xquery");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.PREPARE, new TCommandValue(tPreparedXQuery.getExpression()));
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TXQueryException(tInvocationException.getRootTCause().getMessage(), (Exception)tInvocationException);
        }
    }

    public synchronized TInputStream execute(TPreparedXQuery tPreparedXQuery) throws TXQueryException {
        Object object;
        String string = tPreparedXQuery.getHandle();
        try {
            if (string == null || string.equals("")) {
                object = this.prepare(tPreparedXQuery);
                string = this.getPreparedHandle((TInputStream)object);
                tPreparedXQuery.setHandle(string);
                ((TInputStream)object).close();
            }
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.severe("Closing response inputStream failed with IOException: " + iOException);
            }
            throw new TXQueryException("Response inputStream failed with IOException");
        }
        Precondition.check(this.getInvocation().supports(TCommand.PREPARE), "Prepared XQuery execution is not supported here. Change to local transaction mode!");
        Precondition.check(string != null && string.length() > 0, "No cursor hanlde given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("exuting prepared xquery");
        }
        object = new TCommandStatement(TCommand.EXECUTE, TCommandValue.PREPARED_XQUERY);
        ((TCommandStatement)object).addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        if (tPreparedXQuery.extVarialbles != null && !tPreparedXQuery.extVarialbles.isEmpty()) {
            Set set = tPreparedXQuery.extVarialbles.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                String string3 = tPreparedXQuery.extVarialbles.get(string2).toString();
                ((TCommandStatement)object).addCommand(TCommand.newCommand("$" + string2), new TCommandValue(string3));
            }
        }
        try {
            return this.invoke((TCommandStatement)object, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TXQueryException(tInvocationException.getRootTCause().getMessage(), (Exception)tInvocationException);
        }
    }

    public synchronized TInputStream admin(String string) throws TAdminException {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.ADMIN, new TCommandValue(string));
        try {
            return this.invoke(tCommandStatement);
        }
        catch (TInvocationException tInvocationException) {
            throw new TAdminException(tInvocationException);
        }
    }

    private synchronized TInputStream process(TDataObject tDataObject, String string, String string2) throws TInvocationException {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.PROCESS, new TCommandValue(tDataObject));
        if (this.getMaximumRequestDuration() != 0L) {
            tCommandStatement.addCommandParameter(TCommandParameter.MAXIMUMREQUESTDURATION, new TCommandParameterValue(String.valueOf(this.getMaximumRequestDuration())));
        }
        if (string != null && string2 != null) {
            return this.invoke(tCommandStatement, this.getAccessCollection(), string, string2);
        }
        return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
    }

    public void cancelRequests() throws TAdminException {
        try {
            TConnection tConnection = TConnectionFactory.getInstance().newConnection(this.getDatabaseUri().getAsString());
            TSystemAccessorImpl tSystemAccessorImpl = (TSystemAccessorImpl)tConnection.newSystemAccessor();
            tSystemAccessorImpl.clientRequests = this.clientRequests;
            tSystemAccessorImpl.cancelRequests();
        }
        catch (TServerNotAvailableException tServerNotAvailableException) {
            throw new TAdminException(tServerNotAvailableException);
        }
    }

    public void setScrollType(TScroll tScroll) {
        this.scrollType = tScroll;
    }

    public TScroll getScrollType() {
        return this.scrollType;
    }

    private String getPreparedHandle(TInputStream tInputStream) throws IOException {
        String string = "";
        if (tInputStream.hasReturnValue() && tInputStream.getReturnValue().equalsIgnoreCase("0")) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = tInputStream.read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = tInputStream.read();
            }
            string = this.searchHandle(stringBuffer, TInoNamespace.HANDLE.getQualifiedName(), 3);
        }
        return string;
    }

    private String searchHandle(StringBuffer stringBuffer, String string, int n) {
        String string2 = null;
        int n2 = stringBuffer.indexOf(string);
        int n3 = string.length();
        if (n > 0) {
            string2 = stringBuffer.substring(n2 + n3);
        } else if (n == 0) {
            string2 = stringBuffer.substring(0, n2 + (n3 - 1));
        }
        switch (n) {
            case 3: {
                string = "=";
                break;
            }
            case 2: {
                string = "\"";
                break;
            }
            case 1: {
                string = "\"";
            }
        }
        if (n > 0) {
            string2 = this.searchHandle(new StringBuffer(string2), string, --n);
        }
        return string2;
    }
}

